/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.iceberg;

import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.BeforeTestWithContext;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.testng.services.Flaky;
import io.prestosql.tests.hive.util.TemporaryHiveTable;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestIcebergCreateTable
extends ProductTest {
    @BeforeTestWithContext
    public void setUp() {
        QueryExecutors.onPresto().executeQuery("CREATE SCHEMA IF NOT EXISTS iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void cleanUp() {
        QueryExecutors.onPresto().executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4864", match="Failed to read footer of file")
    public void testCreateTable() {
        String tableName = "iceberg.iceberg.test_create_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + "(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onPresto().executeQuery("INSERT INTO " + tableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onPresto().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"iceberg", "storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4864", match="Failed to read footer of file")
    public void testCreateTableAsSelect() {
        String tableName = "iceberg.iceberg.test_create_table_as_select_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM (VALUES   (NULL, NULL),   (-42, 'abc'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')) t(a, b)", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onPresto().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

