/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.kafka;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.prestosql.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.util.List;
import org.testng.annotations.Test;

public class TestKafkaAvroWritesSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String ALL_DATATYPES_AVRO_TABLE_NAME = "product_tests.write_all_datatypes_avro";
    private static final String ALL_DATATYPES_AVRO_TOPIC_NAME = "write_all_datatypes_avro";
    private static final String STRUCTURAL_AVRO_TABLE_NAME = "product_tests.write_structural_datatype_avro";
    private static final String STRUCTURAL_AVRO_TOPIC_NAME = "write_structural_datatype_avro";

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesAvroTable.class})
    public void testInsertPrimitiveDataType() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("INSERT INTO %s.%s VALUES ('jasio', 9223372036854775807, 1234567890.123456789, true), ('stasio', -9223372036854775808, -1234567890.123456789, false), (null, null, null, null), ('krzysio', 9223372036854775807, 1234567890.123456789, false), ('kasia', 9223372036854775807, null, null)", KAFKA_CATALOG, ALL_DATATYPES_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(5);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s.%s", KAFKA_CATALOG, ALL_DATATYPES_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", Long.MAX_VALUE, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"stasio", Long.MIN_VALUE, -1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"krzysio", Long.MAX_VALUE, 1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{"kasia", Long.MAX_VALUE, null, null})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={StructuralDataTypeTable.class})
    public void testInsertStructuralDataType() {
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("INSERT INTO %s.%s VALUES (ARRAY[100, 102], map_from_entries(ARRAY[('key1', 'value1')]))", KAFKA_CATALOG, STRUCTURAL_AVRO_TABLE_NAME), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessageMatching("java.sql.SQLException: Query failed \\(.+\\): Unsupported column type 'array\\(bigint\\)' for column 'c_array'");
    }

    private static class StructuralDataTypeTable
    implements RequirementsProvider {
        private StructuralDataTypeTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition(TestKafkaAvroWritesSmokeTest.STRUCTURAL_AVRO_TABLE_NAME, TestKafkaAvroWritesSmokeTest.STRUCTURAL_AVRO_TOPIC_NAME, (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }

    private static class AllDataTypesAvroTable
    implements RequirementsProvider {
        private AllDataTypesAvroTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition(TestKafkaAvroWritesSmokeTest.ALL_DATATYPES_AVRO_TABLE_NAME, TestKafkaAvroWritesSmokeTest.ALL_DATATYPES_AVRO_TOPIC_NAME, (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }
}

