/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.utils;

import io.prestosql.jdbc.PrestoConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class JdbcDriverUtils {
    public static void setRole(Connection connection, String role) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SET ROLE " + role);
        }
    }

    public static String getSessionProperty(Connection connection, String key) throws SQLException {
        return JdbcDriverUtils.getSessionProperty(connection, key, "Value");
    }

    public static String getSessionPropertyDefault(Connection connection, String key) throws SQLException {
        return JdbcDriverUtils.getSessionProperty(connection, key, "Default");
    }

    private static String getSessionProperty(Connection connection, String key, String valueType) throws SQLException {
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("SHOW SESSION");
            while (rs.next()) {
                if (!rs.getString("Name").equals(key)) continue;
                String string = rs.getString(valueType);
                return string;
            }
        }
        return null;
    }

    public static void setSessionProperty(Connection connection, String key, String value) throws SQLException {
        PrestoConnection prestoConnection = connection.unwrap(PrestoConnection.class);
        prestoConnection.setSessionProperty(key, value);
    }

    public static void resetSessionProperty(Connection connection, String key) throws SQLException {
        JdbcDriverUtils.setSessionProperty(connection, key, JdbcDriverUtils.getSessionPropertyDefault(connection, key));
    }

    private JdbcDriverUtils() {
    }
}

