/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cassandra;

import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tests.cassandra.CassandraTpchTableDefinitions;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidTable() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Table '%s' does not exist", tableName));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidSchema() {
        String tableName = String.format("%s.%s.%s", "cassandra", "does_not_exist", "bogus");
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Schema 'does_not_exist' does not exist");
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidColumn() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryAssert.assertThat(() -> QueryExecutor.query((String)String.format("SELECT bogus FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Column 'bogus' cannot be resolved");
    }
}

