/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.prestosql.tempto.AfterTestWithContext;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.ldap.LdapObjectRequirement;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.process.CliProcess;
import io.prestosql.tests.ImmutableLdapObjectDefinitions;
import io.prestosql.tests.cli.PrestoCliLauncher;
import io.prestosql.tests.cli.PrestoCliProcess;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPrestoLdapCli
extends PrestoCliLauncher
implements RequirementsProvider {
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_truststore_path")
    private String ldapTruststorePath;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_truststore_password")
    private String ldapTruststorePassword;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_user_name")
    private String ldapUserName;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_server_address")
    private String ldapServerAddress;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_ldap_user_password")
    private String ldapUserPassword;

    @Override
    @AfterTestWithContext
    public void stopPresto() throws InterruptedException {
        super.stopPresto();
    }

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{new LdapObjectRequirement(Arrays.asList(ImmutableLdapObjectDefinitions.AMERICA_ORG, ImmutableLdapObjectDefinitions.ASIA_ORG, ImmutableLdapObjectDefinitions.DEFAULT_GROUP, ImmutableLdapObjectDefinitions.PARENT_GROUP, ImmutableLdapObjectDefinitions.CHILD_GROUP, ImmutableLdapObjectDefinitions.DEFAULT_GROUP_USER, ImmutableLdapObjectDefinitions.PARENT_GROUP_USER, ImmutableLdapObjectDefinitions.CHILD_GROUP_USER, ImmutableLdapObjectDefinitions.ORPHAN_USER, ImmutableLdapObjectDefinitions.SPECIAL_USER, ImmutableLdapObjectDefinitions.USER_IN_MULTIPLE_GROUPS)), TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION)});
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryWithLdap() throws IOException {
        this.launchPrestoCliWithServerArgument(new String[0]);
        this.presto.waitForPrompt();
        this.presto.getProcessInput().println("select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines(this.presto.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunBatchQueryWithLdap() throws IOException {
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldRunQueryFromFileWithLdap() throws IOException {
        File temporayFile = File.createTempFile("test-sql", null);
        temporayFile.deleteOnExit();
        Files.write((CharSequence)"select * from hive.default.nation;\n", (File)temporayFile, (Charset)StandardCharsets.UTF_8);
        this.launchPrestoCliWithServerArgument("--file", temporayFile.getAbsolutePath());
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldPassQueryForLdapUserInMultipleGroups() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.USER_IN_MULTIPLE_GROUPS.getAttributes().get("cn");
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapUserInChildGroup() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.CHILD_GROUP_USER.getAttributes().get("cn");
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapUserInParentGroup() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.PARENT_GROUP_USER.getAttributes().get("cn");
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForOrphanLdapUser() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.ORPHAN_USER.getAttributes().get("cn");
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{String.format("User [%s] not a member of an authorized group", this.ldapUserName)}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForWrongLdapPassword() throws IOException {
        this.ldapUserPassword = "wrong_password";
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Invalid credentials"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForWrongLdapUser() throws IOException {
        this.ldapUserName = "invalid_user";
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Access Denied"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForEmptyUser() throws IOException {
        this.ldapUserName = "";
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Malformed credentials: user is empty"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapWithoutPassword() throws IOException {
        this.launchPrestoCli("--server", this.ldapServerAddress, "--truststore-path", this.ldapTruststorePath, "--truststore-password", this.ldapTruststorePassword, "--user", this.ldapUserName, "--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Authentication failed: Unauthorized"}));
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailQueryForLdapWithoutHttps() throws IOException {
        this.ldapServerAddress = String.format("http://%s:8443", this.serverHost);
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Authentication using username/password requires HTTPS to be enabled"}));
        this.skipAfterTestWithContext();
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailForIncorrectTrustStore() throws IOException {
        this.ldapTruststorePassword = "wrong_password";
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Keystore was tampered with, or password was incorrect"}));
        this.skipAfterTestWithContext();
    }

    private void skipAfterTestWithContext() {
        this.presto.close();
        this.presto = null;
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldPassForCredentialsWithSpecialCharacters() throws IOException {
        this.ldapUserName = (String)ImmutableLdapObjectDefinitions.SPECIAL_USER.getAttributes().get("cn");
        this.ldapUserPassword = (String)ImmutableLdapObjectDefinitions.SPECIAL_USER.getAttributes().get("userPassword");
        this.launchPrestoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
    }

    @Test(groups={"ldap", "ldap_cli", "profile_specific_tests"}, timeOut=300000L)
    public void shouldFailForUserWithColon() throws IOException {
        this.ldapUserName = "UserWith:Colon";
        this.launchPrestoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.presto.readRemainingErrorLines())).anySatisfy(line -> Assertions.assertThat((String)line).contains(new CharSequence[]{"Illegal character ':' found in username"}));
        this.skipAfterTestWithContext();
    }

    private void launchPrestoCliWithServerArgument(String ... arguments) throws IOException {
        Objects.requireNonNull(this.ldapTruststorePath, "databases.presto.cli_ldap_truststore_path is null");
        Objects.requireNonNull(this.ldapTruststorePassword, "databases.presto.cli_ldap_truststore_password is null");
        Objects.requireNonNull(this.ldapUserName, "databases.presto.cli_ldap_user_name is null");
        Objects.requireNonNull(this.ldapServerAddress, "databases.presto.cli_ldap_server_address is null");
        Objects.requireNonNull(this.ldapUserPassword, "databases.presto.cli_ldap_user_password is null");
        ImmutableList.Builder prestoClientOptions = ImmutableList.builder();
        prestoClientOptions.add((Object[])new String[]{"--server", this.ldapServerAddress, "--truststore-path", this.ldapTruststorePath, "--truststore-password", this.ldapTruststorePassword, "--user", this.ldapUserName, "--password"});
        prestoClientOptions.add((Object[])arguments);
        ProcessBuilder processBuilder = this.getProcessBuilder((List<String>)prestoClientOptions.build());
        processBuilder.environment().put("PRESTO_PASSWORD", this.ldapUserPassword);
        this.presto = new PrestoCliProcess(processBuilder.start());
    }
}

