/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.testng.services.Flaky;
import io.prestosql.tests.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.Test;

public class TestCsv
extends ProductTest {
    @Test(groups={"storage_formats"})
    public void testInsertIntoCsvTable() {
        this.testInsertIntoCsvTable("storage_formats_test_insert_into_csv", "");
    }

    @Test(groups={"storage_formats"})
    public void testInsertIntoCsvTableWithCustomProperties() {
        this.testInsertIntoCsvTable("storage_formats_test_insert_into_csv_with_custom_properties", ", csv_escape = 'e', csv_separator='s', csv_quote='q'");
    }

    private void testInsertIntoCsvTable(String tableName, String additionalTableProperties) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(  name varchar,   comment varchar ) WITH (format='CSV' %s)", tableName, additionalTableProperties), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT name, comment FROM tpch.tiny.nation", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("SELECT max(name), max(comment) FROM %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreateCsvTableAs() {
        this.testCreateCsvTableAs("");
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreateCsvTableAsWithCustomProperties() {
        this.testCreateCsvTableAs(", csv_escape = 'e', csv_separator = 's', csv_quote = 'q'");
    }

    private void testCreateCsvTableAs(String additionalParameters) {
        String tableName = "test_csv_table";
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (format='CSV' %s) AS SELECT CAST(nationkey AS varchar) AS nationkey, CAST(name AS varchar) AS name, CAST(comment AS varchar) AS comment FROM tpch.tiny.nation", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("SELECT max(name), max(comment) FROM %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInsertIntoPartitionedCsvTable() {
        this.testInsertIntoPartitionedCsvTable("test_partitioned_csv_table", "");
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInsertIntoPartitionedCsvTableWithCustomProperties() {
        this.testInsertIntoPartitionedCsvTable("test_partitioned_csv_table_with_custom_parameters", ", csv_escape = 'e', csv_separator = 's', csv_quote = 'q'");
    }

    private void testInsertIntoPartitionedCsvTable(String tableName, String additionalParameters) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s(  name varchar,   comment varchar,   regionkey bigint ) WITH (format='CSV' %s, partitioned_by = ARRAY['regionkey'])", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s SELECT name, comment, regionkey FROM tpch.tiny.nation", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("SELECT max(name), max(comment), max(regionkey) FROM %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreatePartitionedCsvTableAs() {
        this.testCreatePartitionedCsvTableAs("storage_formats_test_create_table_as_select_partitioned_csv", "");
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreatePartitionedCsvTableAsWithCustomParamters() {
        this.testCreatePartitionedCsvTableAs("storage_formats_test_create_table_as_select_partitioned_csv_with_custom_parameters", ", csv_escape = 'e', csv_separator='s', csv_quote='q'");
    }

    private void testCreatePartitionedCsvTableAs(String tableName, String additionalParameters) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("CREATE TABLE %s WITH (format='CSV', partitioned_by = ARRAY['regionkey'] %s) AS SELECT cast(nationkey AS varchar) AS nationkey, cast(name AS varchar) AS name, regionkey FROM tpch.tiny.nation", tableName, additionalParameters), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestCsv.assertSelect("SELECT max(name), max(regionkey) FROM %s", tableName);
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertSelect(String query, String tableName) {
        QueryResult expected = QueryExecutor.query((String)String.format(query, "tpch.tiny.nation"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        List expectedRows = (List)expected.rows().stream().map(columns -> QueryAssert.Row.row((Object[])columns.toArray())).collect(ImmutableList.toImmutableList());
        QueryResult actual = QueryExecutor.query((String)String.format(query, tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actual).hasColumns(expected.getColumnTypes()).containsOnly(expectedRows);
    }

    @Test(groups={"storage_formats"})
    public void testReadCsvTableWithMultiCharProperties() {
        String tableName = "storage_formats_test_read_csv_table_with_multi_char_properties";
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s(   a  string,   b  string,   c  string) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde' WITH SERDEPROPERTIES ('escapeChar'='ee','separatorChar'='ss','quoteChar'='qq') STORED AS INPUTFORMAT 'org.apache.hadoop.mapred.TextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s(a, b, c) VALUES ('1', 'a', 'A'), ('2', 'b', 'B'), ('3', 'c', 'C')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "a", "A"}), QueryAssert.Row.row((Object[])new Object[]{"2", "b", "B"}), QueryAssert.Row.row((Object[])new Object[]{"3", "c", "C"})});
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testWriteCsvTableWithMultiCharProperties() {
        String tableName = "storage_formats_test_write_csv_table_with_multi_char_properties";
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s(   a  string,   b  string,   c  string) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde' WITH SERDEPROPERTIES ('escapeChar'='ee','separatorChar'='ss','quoteChar'='qq') STORED AS INPUTFORMAT 'org.apache.hadoop.mapred.TextInputFormat' OUTPUTFORMAT 'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)String.format("INSERT INTO %s(a, b, c) VALUES ('1', 'a', 'A'), ('2', 'b', 'B'), ('3', 'c', 'C')", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s", tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1", "a", "A"}), QueryAssert.Row.row((Object[])new Object[]{"2", "b", "B"}), QueryAssert.Row.row((Object[])new Object[]{"3", "c", "C"})});
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }
}

