/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.inject.Inject;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.MutableTablesState;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableInstance;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.HiveTableDefinitions;
import io.prestosql.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestExternalHiveTable
extends ProductTest
implements RequirementsProvider {
    private static final String HIVE_CATALOG_WITH_EXTERNAL_WRITES = "hive_with_external_writes";
    private static final String EXTERNAL_TABLE_NAME = "target_table";
    @Inject
    private HdfsClient hdfsClient;

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY)});
    }

    @Test
    public void testShowStatisticsForExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/target_table_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE target_table PARTITION (p_regionkey) COMPUTE STATISTICS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SHOW STATS FOR target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_name", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
        QueryExecutors.onHive().executeQuery("ANALYZE TABLE target_table PARTITION (p_regionkey) COMPUTE STATISTICS FOR COLUMNS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SHOW STATS FOR target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"p_nationkey", null, 5.0, 0.0, null, "1", "24"}), QueryAssert.Row.row((Object[])new Object[]{"p_name", 38.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_comment", 499.0, 5.0, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"p_regionkey", null, 1.0, 0.0, null, "1", "1"}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 5.0, null, null})});
    }

    @Test
    public void testAnalyzeExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/target_table_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"ANALYZE hive.default.target_table", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
    }

    @Test
    public void testInsertIntoExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("INSERT INTO hive.default.target_table SELECT * FROM hive.default." + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot write to non-managed Hive table");
    }

    @Test
    public void testDeleteFromExternalTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(TpchTableDefinitions.NATION.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase(), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table", new QueryExecutor.QueryParam[0])).failsWithMessage("Cannot delete from non-managed Hive table");
    }

    @Test
    public void testDeleteFromExternalPartitionedTableTable() {
        TableInstance nation = MutableTablesState.mutableTablesState().get(HiveTableDefinitions.NATION_PARTITIONED_BY_BIGINT_REGIONKEY.getName());
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS target_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE EXTERNAL TABLE target_table LIKE " + nation.getNameInDatabase() + " LOCATION '/tmp/target_table_" + nation.getNameInDatabase() + "'", new QueryExecutor.QueryParam[0]);
        this.insertNationPartition(nation, 1);
        this.insertNationPartition(nation, 2);
        this.insertNationPartition(nation, 3);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(15);
        QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table WHERE p_name IS NOT NULL", new QueryExecutor.QueryParam[0])).failsWithMessage("Deletes must match whole partitions for non-transactional tables");
        QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table WHERE p_regionkey = 1", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(10);
        QueryExecutors.onPresto().executeQuery("DELETE FROM hive.default.target_table", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM target_table", new QueryExecutor.QueryParam[0])).hasRowsCount(0);
    }

    @Test(groups={"hive_with_external_writes", "profile_specific_tests"})
    public void testCreateExternalTableWithInaccessibleSchemaLocation() {
        String schema = "schema_without_location";
        String schemaLocation = "/tmp/" + schema;
        this.hdfsClient.createDirectory(schemaLocation);
        QueryExecutor.query((String)String.format("CREATE SCHEMA %s.%s WITH (location='%s')", HIVE_CATALOG_WITH_EXTERNAL_WRITES, schema, schemaLocation), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        this.hdfsClient.delete(schemaLocation);
        String table = "test_create_external";
        String tableLocation = "/tmp/" + table;
        QueryExecutor.query((String)String.format("CREATE TABLE %s.%s.%s WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", HIVE_CATALOG_WITH_EXTERNAL_WRITES, schema, table, tableLocation), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private void insertNationPartition(TableInstance<?> nation, int partition) {
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE target_table PARTITION (p_regionkey=" + partition + ") SELECT p_nationkey, p_name, p_comment FROM " + nation.getNameInDatabase() + " WHERE p_regionkey=" + partition, new QueryExecutor.QueryParam[0]);
    }
}

