/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.hive.util.CachingTestUtils;
import io.prestosql.tests.utils.QueryAssertions;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCaching
extends ProductTest {
    private static final int NUMBER_OF_FILES = 5;

    @Test(groups={"hive_caching", "profile_specific_tests"})
    public void testReadFromCache() {
        this.testReadFromTable("table1");
        this.testReadFromTable("table2");
    }

    private void testReadFromTable(String tableNameSuffix) {
        String cachedTableName = "hive.default.test_cache_read" + tableNameSuffix;
        String nonCachedTableName = "hivenoncached.default.test_cache_read" + tableNameSuffix;
        QueryAssert.Row[] tableData = this.createTestTable(nonCachedTableName);
        CachingTestUtils.CacheStats beforeCacheStats = CachingTestUtils.getCacheStats();
        long initialRemoteReads = beforeCacheStats.getRemoteReads();
        long initialCachedReads = beforeCacheStats.getCachedReads();
        long initialNonLocalReads = beforeCacheStats.getNonLocalReads();
        long initialAsyncDownloadedMb = beforeCacheStats.getAsyncDownloadedMb();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + cachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(tableData);
        QueryAssertions.assertEventually(new Duration(20.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats();
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(afterQueryCacheStats.getAsyncDownloadedMb()), (Comparable)Long.valueOf(initialAsyncDownloadedMb + 5L));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(afterQueryCacheStats.getRemoteReads()), (Comparable)Long.valueOf(initialRemoteReads));
            Assert.assertEquals((long)afterQueryCacheStats.getCachedReads(), (long)initialCachedReads);
            Assert.assertEquals((long)afterQueryCacheStats.getNonLocalReads(), (long)initialNonLocalReads);
        });
        QueryAssertions.assertEventually(new Duration(10.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats beforeQueryCacheStats = CachingTestUtils.getCacheStats();
            long beforeQueryCachedReads = beforeQueryCacheStats.getCachedReads();
            long beforeQueryRemoteReads = beforeQueryCacheStats.getRemoteReads();
            long beforeQueryNonLocalReads = beforeQueryCacheStats.getNonLocalReads();
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + cachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(tableData);
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats();
            Assertions.assertGreaterThan((Comparable)Long.valueOf(afterQueryCacheStats.getCachedReads()), (Comparable)Long.valueOf(beforeQueryCachedReads));
            Assert.assertEquals((long)afterQueryCacheStats.getRemoteReads(), (long)beforeQueryRemoteReads);
            Assert.assertEquals((long)afterQueryCacheStats.getNonLocalReads(), (long)beforeQueryNonLocalReads);
        });
        QueryExecutor.query((String)("DROP TABLE " + nonCachedTableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private QueryAssert.Row[] createTestTable(String tableName) {
        StringBuilder randomDataBuilder = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 500000; ++i) {
            randomDataBuilder.append(random.nextInt(10));
        }
        String randomData = randomDataBuilder.toString();
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (col varchar) WITH (format='TEXTFILE')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        for (int i = 0; i < 5; ++i) {
            QueryExecutor.query((String)("INSERT INTO " + tableName + " SELECT format('%1$s%1$s%1$s%1$s%1$s', '" + randomData + "')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        }
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{randomData.repeat(5)});
        return Collections.nCopies(5, row).toArray(new QueryAssert.Row[0]);
    }
}

