/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.hadoop.hdfs.HdfsClient;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.testng.services.Flaky;
import io.prestosql.tests.hive.BucketingType;
import io.prestosql.tests.hive.HiveProductTest;
import io.prestosql.tests.hive.TestHiveMetastoreClientFactory;
import io.prestosql.tests.hive.TransactionalTableType;
import io.prestosql.tests.hive.util.TableLocationUtils;
import io.prestosql.tests.hive.util.TemporaryHiveTable;
import io.prestosql.tests.utils.QueryExecutors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveTransactionalTable
extends HiveProductTest {
    private static final Logger log = Logger.get(TestHiveTransactionalTable.class);
    private static final int TEST_TIMEOUT = 900000;
    @Inject
    private TestHiveMetastoreClientFactory testHiveMetastoreClientFactory;
    @Inject
    private HdfsClient hdfsClient;

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcid() {
        this.doTestReadFullAcid(false, BucketingType.NONE);
    }

    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidBucketed() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidPartitioned() {
        this.doTestReadFullAcid(true, BucketingType.NONE);
    }

    @Test(groups={"hive_transactional", "storage_formats"}, timeOut=900000L)
    public void testReadFullAcidPartitionedBucketed() {
        this.doTestReadFullAcid(true, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadFullAcidBucketedV1() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V1);
    }

    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidBucketedV2() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V2);
    }

    private void doTestReadFullAcid(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("read_full_acid", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col, fcol FROM " + tableName + " ORDER BY col";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (24, 4)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " where fcol=4", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol=2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            String predicate = "fcol = 1" + (isPartitioned ? " AND part_col = 2 " : "");
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE " + predicate, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadInsertOnly(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("insert_only", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            String predicate = isPartitioned ? " WHERE part_col = 2 " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 1", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col FROM " + tableName + predicate + " ORDER BY COL";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + " WHERE col=2"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + " WHERE col=2"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 3", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            if (this.getHiveVersionMajor() >= 4) {
                QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 4", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
                QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4})});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadFullAcidWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Presto Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_full_acid_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE fcol = 1" + (isPartitioned ? " AND part_col = 2 " : ""), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    public void testUpdateFullAcidWithOriginalFilesPrestoInserting(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("presto_update_full_acid_acid_converted_table_read", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            if (isPartitioned) {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol, part_col) VALUES (20, 4, 2)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            } else {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol) VALUES (20, 4)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            }
            if (isPartitioned) {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol, part_col) VALUES (20, 3, 2)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            } else {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol) VALUES (20, 3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            }
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{20, 4}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{20, 4}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
        });
    }

    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    public void testUpdateFullAcidWithOriginalFilesPrestoInsertingAndDeleting(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("presto_update_full_acid_acid_converted_table_read", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (10, 100), (11, 110), (12, 120), (13, 130), (14, 140)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (15, 150), (16, 160), (17, 170), (18, 180), (19, 190)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col < 12"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{11, 110})});
            String fields = isPartitioned ? "(col, fcol, part_col)" : "(col, fcol)";
            QueryExecutor.query((String)String.format("INSERT INTO %s %s VALUES %s", tableName, fields, this.makeValues(30, 5, 2, isPartitioned, 3)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s %s VALUES %s", tableName, fields, this.makeValues(40, 5, 2, isPartitioned, 3)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col IN (11, 12)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col IN (16, 17)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol >= 100"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{14, 140}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{18, 180}), QueryAssert.Row.row((Object[])new Object[]{19, 190})});
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col = 18 OR col = 14 OR (fcol = 2 AND (col / 2) * 2 = col)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT col, fcol FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{19, 190}), QueryAssert.Row.row((Object[])new Object[]{31, 2}), QueryAssert.Row.row((Object[])new Object[]{33, 2}), QueryAssert.Row.row((Object[])new Object[]{41, 2}), QueryAssert.Row.row((Object[])new Object[]{43, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{19, 190}), QueryAssert.Row.row((Object[])new Object[]{31, 2}), QueryAssert.Row.row((Object[])new Object[]{33, 2}), QueryAssert.Row.row((Object[])new Object[]{41, 2}), QueryAssert.Row.row((Object[])new Object[]{43, 2})});
        });
    }

    String makeValues(int colStart, int colCount, int fcol, boolean isPartitioned, int partCol) {
        return IntStream.range(colStart, colStart + colCount - 1).boxed().map(n -> isPartitioned ? String.format("(%s, %s, %s)", n, fcol, partCol) : String.format("(%s, %s)", n, fcol)).collect(Collectors.joining(", "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/prestosql/presto/issues/4927", match="Hive table .* is is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadInsertOnlyWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Presto Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_insert_only_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hive_transactional"})
    public void testFailAcidBeforeHive3() {
        if (this.getHiveVersionMajor() >= 3) {
            throw new SkipException("This tests behavior of ACID table before Hive 3 ");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable("test_fail_acid_before_hive3_" + TemporaryHiveTable.randomTableSuffix());){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + "(a bigint) CLUSTERED BY(a) INTO 4 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Failed to open transaction. Transactional tables support requires Hive metastore version at least 3.0");
        }
    }

    @DataProvider
    public Object[][] partitioningAndBucketingTypeDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCtasAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(String.format("ctas_transactional_%s", TemporaryHiveTable.randomTableSuffix()));){
            String tableName = table.getName();
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " " + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType) + " AS SELECT * FROM (VALUES (21, 1, 1), (22, 1, 2), (23, 2, 2)) t(col, fcol, partcol)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCreateAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("create_transactional", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " (col INTEGER, fcol INTEGER, partcol INTEGER)" + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 2, 3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3})});
        });
    }

    @Test(groups={"hive_transactional"})
    public void testSimpleUnpartitionedTransactionalInsert() {
        this.withTemporaryTable("unpartitioned_transactional_insert", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (11, 100), (12, 200), (13, 300)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{12, 200L}), QueryAssert.Row.row((Object[])new Object[]{13, 300L}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (14, 400), (15, 500), (16, 600)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{12, 200L}), QueryAssert.Row.row((Object[])new Object[]{13, 300L}), QueryAssert.Row.row((Object[])new Object[]{14, 400L}), QueryAssert.Row.row((Object[])new Object[]{15, 500L}), QueryAssert.Row.row((Object[])new Object[]{16, 600L}));
        });
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalPartitionInsert() {
        this.withTemporaryTable("transactional_partition_insert", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 10", QueryAssert.Row.row((Object[])new Object[]{20}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 21, 30), this.makeInsertValues(2, 21, 30)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{20}));
            QueryExecutors.onHive().executeQuery(String.format("DELETE FROM %s WHERE column1 > 15 AND column1 <= 25", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{0}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 20, 23), this.makeInsertValues(2, 20, 23)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{8}));
        });
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalBucketedPartitionedInsert() {
        this.testTransactionalBucketedPartitioned(false);
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalBucketedPartitionedInsertOnly() {
        this.testTransactionalBucketedPartitioned(true);
    }

    private void testTransactionalBucketedPartitioned(boolean insertOnly) {
        this.withTemporaryTable("bucketed_partitioned_insert_only", true, true, BucketingType.BUCKETED_V2, tableName -> {
            String insertOnlyProperty = insertOnly ? ", 'transactional_properties'='insert_only'" : "";
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchase STRING) PARTITIONED BY (customer STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true'%s)", tableName, insertOnlyProperty), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testTransactionalUnpartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INTEGER, column2 BIGINT) WITH (format = 'ORC', transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 = 100", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{2, 200}), QueryAssert.Row.row((Object[])new Object[]{3, 300}), QueryAssert.Row.row((Object[])new Object[]{4, 400}), QueryAssert.Row.row((Object[])new Object[]{5, 500}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (6, 600), (7, 700)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 4", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{2, 200}), QueryAssert.Row.row((Object[])new Object[]{3, 300}), QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{6, 600}), QueryAssert.Row.row((Object[])new Object[]{7, 700}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 <= 3 OR column1 = 6", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{7, 700}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testMultiDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_multi_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (6, 600), (7, 700), (8, 800), (9, 900), (10, 1000)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 9", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 2 OR column1 = 3", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100}), QueryAssert.Row.row((Object[])new Object[]{4, 400}), QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{6, 600}), QueryAssert.Row.row((Object[])new Object[]{7, 700}), QueryAssert.Row.row((Object[])new Object[]{8, 800}), QueryAssert.Row.row((Object[])new Object[]{10, 1000}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testTransactionalMetadataDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("metadata_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 = 1", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 = 1", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testNonTransactionalMetadataDelete() {
        this.withTemporaryTable("non_transactional_metadata_delete", false, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column2 BIGINT, column1 INT) WITH (partitioned_by = ARRAY['column1'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 10), this.makeInsertValues(2, 1, 10)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 11, 20), this.makeInsertValues(2, 11, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("DELETE FROM %s WHERE column1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column1 = 1", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testUnpartitionedDeleteAll(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_delete_all", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, "DELETE FROM " + tableName, new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testMultiColumnDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("multi_column_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            String where = " WHERE column1 >= 2 AND column2 <= 400";
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s %s", tableName, where), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "column1 IN (1, 5)", QueryAssert.Row.row((Object[])new Object[]{1, 100}), QueryAssert.Row.row((Object[])new Object[]{5, 500}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testPartitionAndRowsDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("partition_and_rows_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + " (column2 BIGINT, column1 INT) WITH (transactional = true, partitioned_by = ARRAY['column1'])", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES (1, 100), (1, 200), (2, 300), (2, 400), (2, 500)", tableName), new QueryExecutor.QueryParam[0]);
            String where = " WHERE column1 = 2 OR column2 = 200";
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s %s", tableName, where), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT column1, column2 FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testPartitionedInsertAndRowLevelDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("partitioned_row_level_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column2 INT, column1 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column1'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 21, 40), this.makeInsertValues(2, 21, 40)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 > 10 AND column2 <= 30", QueryAssert.Row.row((Object[])new Object[]{40}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 > 10 AND column2 <= 30", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 > 10 AND column2 <= 30", QueryAssert.Row.row((Object[])new Object[]{0}));
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{40}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testBucketedPartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("bucketed_partitioned_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchase STRING) PARTITIONED BY (customer STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer FROM " + tableName, "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase = 'lemons'", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT purchase FROM " + tableName, "customer = 'Ann'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase like('c%%')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer, purchase FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testBucketedUnpartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("bucketed_unpartitioned_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchase STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer FROM " + tableName, "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase = 'lemons'", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT purchase FROM " + tableName, "customer = 'Ann'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase like('c%%')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer, purchase FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testCorrectSelectCountStar(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("select_count_star_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 BIGINT) PARTITIONED BY (col3 STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100, 'a'), (2, 200, 'b'), (3, 300, 'c'), (4, 400, 'a'), (5, 500, 'b'), (6, 600, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE col2 = 200", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{5}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="insertersProvider", timeOut=900000L)
    public void testInsertOnlyMultipleWriters(boolean bucketed, HiveOrPresto inserter1, HiveOrPresto inserter2) {
        log.info("testInsertOnlyMultipleWriters bucketed %s, inserter1 %s, inserter2 %s", new Object[]{bucketed, inserter1, inserter2});
        this.withTemporaryTable("insert_only_partitioned", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 BIGINT) PARTITIONED BY (col3 STRING) %s STORED AS ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName, bucketed ? "CLUSTERED BY (col2) INTO 3 BUCKETS" : ""), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter1, String.format("INSERT INTO %s VALUES (1, 100, 'a'), (2, 200, 'b')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}));
            TestHiveTransactionalTable.execute(inserter2, String.format("INSERT INTO %s VALUES (3, 300, 'c'), (4, 400, 'a')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}));
            TestHiveTransactionalTable.execute(inserter1, String.format("INSERT INTO %s VALUES (5, 500, 'b'), (6, 600, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}));
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "col2 > 300", QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}));
            TestHiveTransactionalTable.execute(inserter2, String.format("INSERT INTO %s VALUES (7, 700, 'b'), (8, 800, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}), QueryAssert.Row.row((Object[])new Object[]{7, 700, "b"}), QueryAssert.Row.row((Object[])new Object[]{8, 800, "c"}));
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "col3 = 'c'", QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}), QueryAssert.Row.row((Object[])new Object[]{8, 800, "c"}));
        });
    }

    @DataProvider
    public Object[][] insertersProvider() {
        return new Object[][]{{false, HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {false, HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}, {true, HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {true, HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}};
    }

    private static QueryResult execute(HiveOrPresto hiveOrPresto, String sql, QueryExecutor.QueryParam ... params) {
        return TestHiveTransactionalTable.executorFor(hiveOrPresto).executeQuery(sql, params);
    }

    private static QueryExecutor executorFor(HiveOrPresto hiveOrPresto) {
        switch (hiveOrPresto) {
            case HIVE: {
                return QueryExecutors.onHive();
            }
            case PRESTO: {
                return QueryExecutors.onPresto();
            }
        }
        throw new IllegalStateException("Unknown enum value " + hiveOrPresto);
    }

    @DataProvider
    public Object[][] inserterAndDeleterProvider() {
        return new Object[][]{{HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}, {HiveOrPresto.PRESTO, HiveOrPresto.HIVE}};
    }

    void withTemporaryTable(String rootName, boolean transactional, boolean isPartitioned, BucketingType bucketingType, Consumer<String> testRunner) {
        if (transactional) {
            this.ensureTransactionalHive();
        }
        String tableName = null;
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName(rootName, isPartitioned, bucketingType));){
            tableName = table.getName();
            testRunner.accept(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"hive_transactional"})
    @Flaky(issue="https://github.com/prestosql/presto/issues/5463", match="Expected row count to be <4>, but was <6>")
    public void testFilesForAbortedTransactionsIgnored() throws Exception {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_aborted_transaction_table";
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) STORED AS ORC TBLPROPERTIES ('transactional'='true')", new QueryExecutor.QueryParam[0]);
        ThriftHiveMetastoreClient client = this.testHiveMetastoreClientFactory.createMetastoreClient();
        try {
            String selectFromOnePartitionsSql = "SELECT col FROM " + tableName + " ORDER BY COL";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " VALUES (1),(2)", new QueryExecutor.QueryParam[0]);
            QueryResult onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            String tableLocation = TableLocationUtils.getTablePath(tableName);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " SELECT 3", new QueryExecutor.QueryParam[0]);
            long transaction = client.openTransaction("test");
            ((TxnToWriteId)client.allocateTableWriteIds("default", tableName, Collections.singletonList(transaction)).get(0)).getWriteId();
            client.abortTransaction(transaction);
            String deltaA = tableLocation + "/delta_0000001_0000001_0000";
            String deltaB = tableLocation + "/delta_0000002_0000002_0000";
            String deltaC = tableLocation + "/delta_0000003_0000003_0000";
            this.hdfsDeleteAll(deltaB);
            this.hdfsDeleteAll(deltaC);
            this.hdfsCopyAll(deltaA, deltaB);
            onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{2})});
            this.hdfsCopyAll(deltaA, deltaC);
            onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            client.close();
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private void hdfsDeleteAll(String directory) {
        if (!this.hdfsClient.exist(directory)) {
            return;
        }
        for (String file : this.hdfsClient.listDirectory(directory)) {
            this.hdfsClient.delete(directory + "/" + file);
        }
    }

    private void hdfsCopyAll(String source, String target) {
        if (!this.hdfsClient.exist(target)) {
            this.hdfsClient.createDirectory(target);
        }
        for (String file : this.hdfsClient.listDirectory(source)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.hdfsClient.loadFile(source + "/" + file, (OutputStream)bos);
            this.hdfsClient.saveFile(target + "/" + file, (InputStream)new ByteArrayInputStream(bos.toByteArray()));
        }
    }

    @DataProvider
    public Object[][] testCreateAcidTableDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {false, BucketingType.BUCKETED_V1}, {false, BucketingType.BUCKETED_V2}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    private static String hiveTableProperties(TransactionalTableType transactionalTableType, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getHiveTableProperties());
        tableProperties.addAll(bucketingType.getHiveTableProperties());
        tableProperties.add((Object)"'NO_AUTO_COMPACTION'='true'");
        return tableProperties.build().stream().collect(Collectors.joining(",", "TBLPROPERTIES (", ")"));
    }

    private static String prestoTableProperties(TransactionalTableType transactionalTableType, boolean isPartitioned, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getPrestoTableProperties());
        tableProperties.addAll(bucketingType.getPrestoTableProperties("fcol", 4));
        if (isPartitioned) {
            tableProperties.add((Object)"partitioned_by = ARRAY['partcol']");
        }
        return tableProperties.build().stream().collect(Collectors.joining(",", "WITH (", ")"));
    }

    private static void compactTableAndWait(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) {
        log.info("Running %s compaction on %s", new Object[]{compactMode, tableName});
        Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxDuration(java.time.Duration.ofMillis(timeout.toMillis())).withMaxAttempts(Integer.MAX_VALUE)}).onFailure(event -> {
            throw new IllegalStateException(String.format("Could not compact table %s in %d retries", tableName, event.getAttemptCount()), event.getFailure());
        }).onSuccess(event -> log.info("Finished %s compaction on %s in %s (%d tries)", new Object[]{compactMode, tableName, event.getElapsedTime(), event.getAttemptCount()})).run(() -> TestHiveTransactionalTable.tryCompactingTable(compactMode, tableName, partitionString, Duration.valueOf((String)"2m")));
    }

    private static void tryCompactingTable(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) throws TimeoutException {
        List<Map<String, String>> startedCompactions;
        Instant beforeCompactionStart = Instant.now();
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s %s COMPACT '%s'", tableName, partitionString, compactMode.name()), new QueryExecutor.QueryParam[0]).getRowsCount();
        log.info("Started compactions after %s: %s", new Object[]{beforeCompactionStart, TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty())});
        long loopStart = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            startedCompactions = TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.of(beforeCompactionStart));
            Verify.verify((startedCompactions.size() < 2 ? 1 : 0) != 0, (String)"Expected at most 1 compaction", (Object[])new Object[0]);
            if (startedCompactions.isEmpty()) {
                log.info("Compaction has not started yet. Existing compactions: " + TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty()));
                continue;
            }
            String compactionState = startedCompactions.get(0).get("state");
            if (compactionState.equals("failed")) {
                log.info("Compaction has failed: %s", new Object[]{startedCompactions.get(0)});
                throw new IllegalStateException("Compaction has failed");
            }
            if (compactionState.equals("succeeded")) {
                return;
            }
            if (Duration.nanosSince((long)loopStart).compareTo(timeout) > 0) break;
        }
        log.info("Waiting for compaction has timed out: %s", new Object[]{startedCompactions.get(0)});
        throw new TimeoutException("Compaction has timed out");
    }

    private static List<Map<String, String>> getTableCompactions(CompactionMode compactionMode, String tableName, Optional<Instant> startedAfter) {
        return (List)Stream.of(QueryExecutors.onHive().executeQuery("SHOW COMPACTIONS", new QueryExecutor.QueryParam[0])).flatMap(TestHiveTransactionalTable::mapRows).filter(row -> TestHiveTransactionalTable.isCompactionForTable(compactionMode, tableName, row)).filter(row -> {
            if (startedAfter.isPresent()) {
                try {
                    return Long.parseLong((String)row.get("start time")) >= ((Instant)startedAfter.get()).truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }).collect(ImmutableList.toImmutableList());
    }

    private static Stream<Map<String, String>> mapRows(QueryResult result) {
        if (result.getRowsCount() == 0) {
            return Stream.of(new Map[0]);
        }
        List columnNames = result.row(0).stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int rowIndex = 1; rowIndex < result.getRowsCount(); ++rowIndex) {
            ImmutableMap.Builder singleRow = ImmutableMap.builder();
            List row = result.row(rowIndex);
            for (int column = 0; column < columnNames.size(); ++column) {
                String columnName = ((String)columnNames.get(column)).toLowerCase(Locale.ENGLISH);
                singleRow.put((Object)columnName, (Object)((String)row.get(column)));
            }
            rows.add((Object)singleRow.build());
        }
        return rows.build().stream();
    }

    private static String tableName(String testName, boolean isPartitioned, BucketingType bucketingType) {
        return String.format("test_%s_%b_%s_%s", testName, isPartitioned, bucketingType.name(), TemporaryHiveTable.randomTableSuffix());
    }

    private static boolean isCompactionForTable(CompactionMode compactMode, String tableName, Map<String, String> row) {
        return row.get("table").equals(tableName.toLowerCase(Locale.ENGLISH)) && row.get("type").equals(compactMode.name());
    }

    private String makeInsertValues(int col1Value, int col2First, int col2Last) {
        Preconditions.checkArgument((col2First <= col2Last ? 1 : 0) != 0, (String)"The first value %s must be less or equal to the last %s", (int)col2First, (int)col2Last);
        return IntStream.rangeClosed(col2First, col2Last).mapToObj(i -> String.format("(%s, %s)", col1Value, i)).collect(Collectors.joining(", "));
    }

    private void ensureTransactionalHive() {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
    }

    private void verifySelectForPrestoAndHive(String select, String whereClause, QueryAssert.Row ... rows) {
        this.verifySelect(QueryExecutors.onPresto(), select, whereClause, rows);
        this.verifySelect(QueryExecutors.onHive(), select, whereClause, rows);
    }

    private void verifySelect(QueryExecutor executor, String select, String whereClause, QueryAssert.Row ... rows) {
        String fullQuery = String.format("%s WHERE %s", select, whereClause);
        QueryAssert.assertThat((QueryResult)executor.executeQuery(fullQuery, new QueryExecutor.QueryParam[0])).containsOnly(rows);
    }

    public static enum CompactionMode {
        MAJOR,
        MINOR;

    }

    private static enum HiveOrPresto {
        HIVE,
        PRESTO;

    }
}

