/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.jdbc;

import io.prestosql.jdbc.PrestoConnection;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.Requirements;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.MutableTableRequirement;
import io.prestosql.tempto.fulfillment.table.MutableTablesState;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestosql.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.prestosql.tempto.internal.convention.SqlResultDescriptor;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.utils.JdbcDriverUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestJdbc
extends ProductTest {
    private static final String TABLE_NAME = "nation_table_name";

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQuery() throws SQLException {
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "select * from hive.default.nation");
            QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableAndMutableNationTable.class})
    public void shouldInsertSelectQuery() throws SQLException {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
        try (Statement statement = this.connection().createStatement();){
            Assertions.assertThat((int)statement.executeUpdate("insert into " + tableNameInDatabase + " select * from nation")).isEqualTo(25);
        }
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldExecuteQueryWithSelectedCatalogAndSchema() throws SQLException {
        this.connection().setCatalog("hive");
        this.connection().setSchema("default");
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "select * from nation");
            QueryAssert.assertThat((QueryResult)result).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetTimezone() throws SQLException {
        String timeZoneId = "Indian/Kerguelen";
        ((PrestoConnection)this.connection()).setTimeZoneId(timeZoneId);
        this.assertConnectionTimezone(this.connection(), timeZoneId);
    }

    private void assertConnectionTimezone(Connection connection, String timeZoneId) throws SQLException {
        try (Statement statement = connection.createStatement();){
            QueryResult result = this.queryResult(statement, "select current_timezone()");
            QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{timeZoneId})});
        }
    }

    @Test(groups={"jdbc"})
    public void shouldSetLocale() throws SQLException {
        ((PrestoConnection)this.connection()).setLocale(Locale.CHINESE);
        try (Statement statement = this.connection().createStatement();){
            QueryResult result = this.queryResult(statement, "SELECT date_format(TIMESTAMP '2001-01-09 09:04', '%M')");
            QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"\u4e00\u6708"})});
        }
    }

    @Test(groups={"jdbc"})
    public void shouldGetSchemas() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getSchemas("hive", null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", "hive"})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTables() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTables("hive", null, null, null));
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "default", "nation", "TABLE", null, null, null, null, null, null})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetColumns() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getColumns("hive", "default", "nation", null));
        QueryAssert.assertThat((QueryResult)result).matches(SqlResultDescriptor.sqlResultDescriptorForResource((String)"io/prestosql/tests/jdbc/get_nation_columns.result"));
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    public void shouldGetTableTypes() throws SQLException {
        QueryResult result = QueryResult.forResultSet((ResultSet)this.metaData().getTableTypes());
        QueryAssert.assertThat((QueryResult)result).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"VIEW"})});
    }

    @Test(groups={"jdbc"})
    public void testSessionProperties() throws SQLException {
        String joinDistributionType = "join_distribution_type";
        String defaultValue = "AUTOMATIC";
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo(defaultValue);
        JdbcDriverUtils.setSessionProperty(this.connection(), joinDistributionType, "BROADCAST");
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo("BROADCAST");
        JdbcDriverUtils.resetSessionProperty(this.connection(), joinDistributionType);
        Assertions.assertThat((String)JdbcDriverUtils.getSessionProperty(this.connection(), joinDistributionType)).isEqualTo(defaultValue);
    }

    @Test(groups={"jdbc"})
    public void testDeallocate() throws Exception {
        try (Connection connection = this.connection();){
            for (int i = 0; i < 200; ++i) {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT '" + "a".repeat(300) + "'");){
                    preparedStatement.executeQuery().close();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed at " + i, e);
                }
            }
        }
    }

    private QueryResult queryResult(Statement statement, String query) throws SQLException {
        return QueryResult.forResultSet((ResultSet)statement.executeQuery(query));
    }

    private DatabaseMetaData metaData() throws SQLException {
        return this.connection().getMetaData();
    }

    private Connection connection() {
        return QueryExecutor.defaultQueryExecutor().getConnection();
    }

    private static class ImmutableAndMutableNationTable
    implements RequirementsProvider {
        private ImmutableAndMutableNationTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.NATION), TableRequirements.mutableTable((TableDefinition)TpchTableDefinitions.NATION, (String)TestJdbc.TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED)});
        }
    }
}

