/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.jdbc;

import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.prestosql.tempto.query.QueryResult;
import io.prestosql.tests.ImmutableLdapObjectDefinitions;
import io.prestosql.tests.TpchTableResults;
import io.prestosql.tests.jdbc.BaseLdapJdbcTest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLdapPrestoJdbc
extends BaseLdapJdbcTest {
    @Override
    protected String getLdapUrlFormat() {
        return "jdbc:presto://%s?SSL=true&SSLTrustStorePath=%s&SSLTrustStorePassword=%s";
    }

    @Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldRunQueryWithLdap() throws SQLException {
        QueryAssert.assertThat((QueryResult)this.executeLdapQuery("select * from tpch.tiny.nation", this.ldapUserName, this.ldapUserPassword)).matches(TpchTableResults.PRESTO_NATION_RESULT);
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapUserInChildGroup() {
        String name = (String)ImmutableLdapObjectDefinitions.CHILD_GROUP_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapUserInParentGroup() {
        String name = (String)ImmutableLdapObjectDefinitions.PARENT_GROUP_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForOrphanLdapUser() {
        String name = (String)ImmutableLdapObjectDefinitions.ORPHAN_USER.getAttributes().get("cn");
        this.expectQueryToFailForUserNotInGroup(name);
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForWrongLdapPassword() {
        this.expectQueryToFail(this.ldapUserName, "wrong_password", "Authentication failed: Access Denied: Invalid credentials");
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForWrongLdapUser() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> this.executeLdapQuery("select * from tpch.tiny.nation", "invalid_user", this.ldapUserPassword)).isInstanceOf(SQLException.class)).hasMessageStartingWith("Authentication failed");
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForEmptyUser() {
        this.expectQueryToFail("", this.ldapUserPassword, "Connection property 'user' value is empty");
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapWithoutPassword() {
        this.expectQueryToFail(this.ldapUserName, null, "Authentication failed: Unauthorized");
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailQueryForLdapWithoutSsl() {
        try {
            DriverManager.getConnection("jdbc:presto://" + this.prestoServer(), this.ldapUserName, this.ldapUserPassword);
            Assert.fail();
        }
        catch (SQLException exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)"Authentication using username/password requires SSL to be enabled");
        }
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailForIncorrectTrustStore() {
        try {
            String url = String.format("jdbc:presto://%s?SSL=true&SSLTrustStorePath=%s&SSLTrustStorePassword=%s", this.prestoServer(), this.ldapTruststorePath, "wrong_password");
            Connection connection = DriverManager.getConnection(url, this.ldapUserName, this.ldapUserPassword);
            Statement statement = connection.createStatement();
            statement.executeQuery("select * from tpch.tiny.nation");
            Assert.fail();
        }
        catch (SQLException exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)"Error setting up SSL: Keystore was tampered with, or password was incorrect");
        }
    }

    @Test(groups={"ldap", "presto_jdbc", "profile_specific_tests"}, timeOut=30000L)
    public void shouldFailForUserWithColon() {
        this.expectQueryToFail("UserWith:Colon", this.ldapUserPassword, "Illegal character ':' found in username");
    }

    private void expectQueryToFailForUserNotInGroup(String user) {
        this.expectQueryToFail(user, this.ldapUserPassword, String.format("Authentication failed: Access Denied: User [%s] not a member of an authorized group", user));
    }
}

