/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.kafka;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessage;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessageContentsBuilder;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.prestosql.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.testng.annotations.Test;

public class TestKafkaPushdownSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String SCHEMA_NAME = "product_tests";
    private static final long NUM_MESSAGES = 100L;
    private static final long TIMESTAMP_NUM_MESSAGES = 10L;
    private static final String PUSHDOWN_PARTITION_TABLE_NAME = "pushdown_partition";
    private static final String PUSHDOWN_PARTITION_TOPIC_NAME = "pushdown_partition";
    private static final String PUSHDOWN_OFFSET_TABLE_NAME = "pushdown_offset";
    private static final String PUSHDOWN_OFFSET_TOPIC_NAME = "pushdown_offset";
    private static final String PUSHDOWN_CREATE_TIME_TABLE_NAME = "pushdown_create_time";
    private static final String PUSHDOWN_CREATE_TIME_TOPIC_NAME = "pushdown_create_time";

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={PushdownPartitionTable.class})
    public void testPartitionPushdown() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_id = 1", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_partition"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{50L})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={PushdownOffsetTable.class})
    public void testOffsetPushdown() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset BETWEEN 6 AND 10", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset > 5 AND _partition_offset < 10", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{8})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset >= 5 AND _partition_offset <= 10", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{12})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset >= 5 AND _partition_offset < 10", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset > 5 AND _partition_offset <= 10", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _partition_offset = 5", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_offset"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={PushdownCreateTimeTable.class})
    public void testCreateTimePushdown() throws InterruptedException {
        int i = 1;
        while ((long)i <= 10L) {
            QueryExecutor.query((String)String.format("INSERT INTO %s.%s.%s (bigint_key, bigint_value) VALUES (%s, %s)", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_create_time", i, i), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            Thread.sleep(100L);
            ++i;
        }
        long startKey = 4L;
        long endKey = 6L;
        List rows = QueryExecutor.query((String)String.format("SELECT CAST(_timestamp AS VARCHAR) FROM %s.%s.%s WHERE bigint_key IN (" + startKey + ", " + endKey + ") ORDER BY bigint_key", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_create_time"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).rows();
        String startTime = (String)((List)rows.get(0)).get(0);
        String endTime = (String)((List)rows.get(1)).get(0);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT COUNT(*) FROM %s.%s.%s WHERE _timestamp >= TIMESTAMP '%s' AND _timestamp < TIMESTAMP '%s'", KAFKA_CATALOG, SCHEMA_NAME, "pushdown_create_time", startTime, endTime), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{endKey - startKey})});
    }

    private static class PushdownCreateTimeTable
    implements RequirementsProvider {
        private PushdownCreateTimeTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.pushdown_create_time", "pushdown_create_time", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }

    private static class PushdownOffsetTable
    implements RequirementsProvider {
        private PushdownOffsetTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            List records = LongStream.rangeClosed(1L, 100L).boxed().map(i -> new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8(String.format("%s", i % 2L)).build(), KafkaMessageContentsBuilder.contentsBuilder().appendUTF8(String.format("%s", i)).build())).collect(Collectors.toList());
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.pushdown_offset", "pushdown_offset", (KafkaDataSource)new ListKafkaDataSource(records), 2, 1));
        }
    }

    private static class PushdownPartitionTable
    implements RequirementsProvider {
        private PushdownPartitionTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            List records = LongStream.rangeClosed(1L, 100L).boxed().map(i -> new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8(String.format("%s", i % 2L)).build(), KafkaMessageContentsBuilder.contentsBuilder().appendUTF8(String.format("%s", i)).build())).collect(Collectors.toList());
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.pushdown_partition", "pushdown_partition", (KafkaDataSource)new ListKafkaDataSource(records), 2, 1));
        }
    }
}

