/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.kafka;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessage;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaMessageContentsBuilder;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.prestosql.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.testng.annotations.Test;

public class TestKafkaReadsSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String SCHEMA_NAME = "product_tests";
    private static final String SIMPLE_KEY_AND_VALUE_TABLE_NAME = "read_simple_key_and_value";
    private static final String SIMPLE_KEY_AND_VALUE_TOPIC_NAME = "read_simple_key_and_value";
    private static final String ALL_DATATYPES_RAW_TABLE_NAME = "read_all_datatypes_raw";
    private static final String ALL_DATATYPES_RAW_TOPIC_NAME = "read_all_datatypes_raw";
    private static final String ALL_DATATYPES_CSV_TABLE_NAME = "read_all_datatypes_csv";
    private static final String ALL_DATATYPES_CSV_TOPIC_NAME = "read_all_datatypes_csv";
    private static final String ALL_DATATYPES_JSON_TABLE_NAME = "read_all_datatypes_json";
    private static final String ALL_DATATYPES_JSON_TOPIC_NAME = "read_all_datatypes_json";

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={SimpleKeyAndValueTable.class})
    public void testSelectSimpleKeyAndValue() {
        QueryResult queryResult = QueryExecutor.query((String)String.format("select varchar_key, bigint_key, varchar_value, bigint_value from %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "read_simple_key_and_value"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", 1, "ania", 2}), QueryAssert.Row.row((Object[])new Object[]{"piotr", 3, "kasia", 4})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesRawTable.class})
    public void testSelectAllRawTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select column_name,data_type from %s.information_schema.columns where table_schema='%s' and table_name='%s'", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_raw"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_byte_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_short_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_int_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_long_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_byte_integer", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_short_integer", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_int_integer", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_byte_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_short_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_byte_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"c_float_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_double_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_byte_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_short_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_int_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_long_boolean", "boolean"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select * from %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_raw"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", 1, 515, 67438087, 579005069656919567L, 16, 4370, 320083222, 23, 6169, 26, Float.valueOf(0.13f), 0.45, true, true, true, true})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesCsvTable.class})
    public void testSelectAllCsvTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select column_name,data_type from %s.information_schema.columns where table_schema='%s' and table_name='%s'", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_csv"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_integer", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", "boolean"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select * from %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_csv"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"stasio", Long.MIN_VALUE, Integer.MIN_VALUE, Short.MIN_VALUE, -128, -1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"krzysio", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{"kasia", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, null, null, null})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesJsonTable.class})
    public void testSelectAllJsonTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select column_name,data_type from %s.information_schema.columns where table_schema='%s' and table_name='%s'", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_json"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"c_varchar", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"c_bigint", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"c_integer", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"c_smallint", "smallint"}), QueryAssert.Row.row((Object[])new Object[]{"c_tinyint", "tinyint"}), QueryAssert.Row.row((Object[])new Object[]{"c_double", "double"}), QueryAssert.Row.row((Object[])new Object[]{"c_boolean", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp_milliseconds_since_epoch", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp_seconds_since_epoch", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp_iso8601", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp_rfc2822", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamp_custom", "timestamp(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_date_iso8601", "date"}), QueryAssert.Row.row((Object[])new Object[]{"c_date_custom", "date"}), QueryAssert.Row.row((Object[])new Object[]{"c_time_milliseconds_since_epoch", "time(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_time_seconds_since_epoch", "time(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_time_iso8601", "time(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_time_custom", "time(3)"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamptz_milliseconds_since_epoch", "timestamp(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamptz_seconds_since_epoch", "timestamp(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamptz_iso8601", "timestamp(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamptz_rfc2822", "timestamp(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timestamptz_custom", "timestamp(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timetz_milliseconds_since_epoch", "time(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timetz_seconds_since_epoch", "time(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timetz_iso8601", "time(3) with time zone"}), QueryAssert.Row.row((Object[])new Object[]{"c_timetz_custom", "time(3) with time zone"})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("select * from %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "read_all_datatypes_json"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ala ma kota", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true, Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 16)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 17)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 18)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 19)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 20)), Date.valueOf(LocalDate.of(2018, 2, 11)), Date.valueOf(LocalDate.of(2018, 2, 13)), Time.valueOf(LocalTime.of(13, 15, 16)), Time.valueOf(LocalTime.of(13, 15, 17)), Time.valueOf(LocalTime.of(13, 15, 18)), Time.valueOf(LocalTime.of(13, 15, 20)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 19, 0, 16)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 19, 0, 17)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 19, 0, 18)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 19, 0, 19)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 19, 0, 20)), Time.valueOf(LocalTime.of(18, 45, 16)), Time.valueOf(LocalTime.of(18, 45, 17)), Time.valueOf(LocalTime.of(18, 45, 18)), Time.valueOf(LocalTime.of(18, 45, 20))})});
    }

    private static KafkaMessage utf8KafkaMessage(String val) {
        return new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8(val).build());
    }

    private static class AllDataTypesJsonTable
    implements RequirementsProvider {
        private AllDataTypesJsonTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.read_all_datatypes_json", "read_all_datatypes_json", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of((Object)TestKafkaReadsSmokeTest.utf8KafkaMessage("{\"j_varchar\"                              : \"ala ma kota\"                    ,\"j_bigint\"                               : \"9223372036854775807\"            ,\"j_integer\"                              : \"2147483647\"                     ,\"j_smallint\"                             : \"32767\"                          ,\"j_tinyint\"                              : \"127\"                            ,\"j_double\"                               : \"1234567890.123456789\"           ,\"j_boolean\"                              : \"true\"                           ,\"j_timestamp_milliseconds_since_epoch\"   : \"1518182116000\"                  ,\"j_timestamp_seconds_since_epoch\"        : \"1518182117\"                     ,\"j_timestamp_iso8601\"                    : \"2018-02-09T13:15:18\"            ,\"j_timestamp_rfc2822\"                    : \"Fri Feb 09 13:15:19 Z 2018\"     ,\"j_timestamp_custom\"                     : \"02/2018/09 13:15:20\"            ,\"j_date_iso8601\"                         : \"2018-02-11\"                     ,\"j_date_custom\"                          : \"2018/13/02\"                     ,\"j_time_milliseconds_since_epoch\"        : \"47716000\"                       ,\"j_time_seconds_since_epoch\"             : \"47717\"                          ,\"j_time_iso8601\"                         : \"13:15:18\"                       ,\"j_time_custom\"                          : \"15:13:20\"                       ,\"j_timestamptz_milliseconds_since_epoch\" : \"1518182116000\"                  ,\"j_timestamptz_seconds_since_epoch\"      : \"1518182117\"                     ,\"j_timestamptz_iso8601\"                  : \"2018-02-09T13:15:18Z\"           ,\"j_timestamptz_rfc2822\"                  : \"Fri Feb 09 13:15:19 Z 2018\"     ,\"j_timestamptz_custom\"                   : \"02/2018/09 13:15:20\"            ,\"j_timetz_milliseconds_since_epoch\"      : \"47716000\"                       ,\"j_timetz_seconds_since_epoch\"           : \"47717\"                          ,\"j_timetz_iso8601\"                       : \"13:15:18Z\"                      ,\"j_timetz_custom\"                        : \"15:13:20\"                       }"))), 1, 1));
        }
    }

    private static class AllDataTypesCsvTable
    implements RequirementsProvider {
        private AllDataTypesCsvTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.read_all_datatypes_csv", "read_all_datatypes_csv", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of((Object)TestKafkaReadsSmokeTest.utf8KafkaMessage("jasio,9223372036854775807,2147483647,32767,127,1234567890.123456789,true"), (Object)TestKafkaReadsSmokeTest.utf8KafkaMessage("stasio,-9223372036854775808,-2147483648,-32768,-128,-1234567890.123456789,blah"), (Object)TestKafkaReadsSmokeTest.utf8KafkaMessage(",,,,,,"), (Object)TestKafkaReadsSmokeTest.utf8KafkaMessage("krzysio,9223372036854775807,2147483647,32767,127,1234567890.123456789,false,extra,fields"), (Object)TestKafkaReadsSmokeTest.utf8KafkaMessage("kasia,9223372036854775807,2147483647,32767"))), 1, 1));
        }
    }

    private static class AllDataTypesRawTable
    implements RequirementsProvider {
        private AllDataTypesRawTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.read_all_datatypes_raw", "read_all_datatypes_raw", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of((Object)new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8("jasio").appendBytes(new int[]{1}).appendBytes(new int[]{2, 3}).appendBytes(new int[]{4, 5, 6, 7}).appendBytes(new int[]{8, 9, 10, 11, 12, 13, 14, 15}).appendBytes(new int[]{16}).appendBytes(new int[]{17, 18}).appendBytes(new int[]{19, 20, 21, 22}).appendBytes(new int[]{23}).appendBytes(new int[]{24, 25}).appendBytes(new int[]{26}).appendIntBigEndian(Float.floatToIntBits(0.13f)).appendLongBigEndian(Double.doubleToRawLongBits(0.45)).appendBytes(new int[]{27}).appendBytes(new int[]{28, 29}).appendBytes(new int[]{30, 31, 32, 33}).appendBytes(new int[]{34, 35, 36, 37, 38, 39, 40, 41}).build()))), 1, 1));
        }
    }

    private static class SimpleKeyAndValueTable
    implements RequirementsProvider {
        private SimpleKeyAndValueTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.read_simple_key_and_value", "read_simple_key_and_value", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of((Object)new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8("jasio,1").build(), KafkaMessageContentsBuilder.contentsBuilder().appendUTF8("ania,2").build()), (Object)new KafkaMessage(KafkaMessageContentsBuilder.contentsBuilder().appendUTF8("piotr,3").build(), KafkaMessageContentsBuilder.contentsBuilder().appendUTF8("kasia,4").build()))), 1, 1));
        }
    }
}

