/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.tests.kafka;

import com.google.common.collect.ImmutableList;
import io.prestosql.tempto.ProductTest;
import io.prestosql.tempto.Requirement;
import io.prestosql.tempto.RequirementsProvider;
import io.prestosql.tempto.Requires;
import io.prestosql.tempto.assertions.QueryAssert;
import io.prestosql.tempto.configuration.Configuration;
import io.prestosql.tempto.fulfillment.table.TableDefinition;
import io.prestosql.tempto.fulfillment.table.TableRequirements;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaDataSource;
import io.prestosql.tempto.fulfillment.table.kafka.KafkaTableDefinition;
import io.prestosql.tempto.fulfillment.table.kafka.ListKafkaDataSource;
import io.prestosql.tempto.query.QueryExecutor;
import io.prestosql.tempto.query.QueryResult;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import org.testng.annotations.Test;

public class TestKafkaWritesSmokeTest
extends ProductTest {
    private static final String KAFKA_CATALOG = "kafka";
    private static final String SCHEMA_NAME = "product_tests";
    private static final String SIMPLE_KEY_AND_VALUE_TABLE_NAME = "write_simple_key_and_value";
    private static final String SIMPLE_KEY_AND_VALUE_TOPIC_NAME = "write_simple_key_and_value";
    private static final String ALL_DATATYPES_RAW_TABLE_NAME = "write_all_datatypes_raw";
    private static final String ALL_DATATYPES_RAW_TOPIC_NAME = "write_all_datatypes_raw";
    private static final String ALL_DATATYPES_CSV_TABLE_NAME = "write_all_datatypes_csv";
    private static final String ALL_DATATYPES_CSV_TOPIC_NAME = "write_all_datatypes_csv";
    private static final String ALL_DATATYPES_JSON_TABLE_NAME = "write_all_datatypes_json";
    private static final String ALL_DATATYPES_JSON_TOPIC_NAME = "write_all_datatypes_json";

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={SimpleKeyAndValueTable.class})
    public void testInsertSimpleKeyAndValue() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("INSERT INTO %s.%s.%s VALUES ('jasio', 1, 'ania', 2), ('piotr', 3, 'kasia', 4)", KAFKA_CATALOG, SCHEMA_NAME, "write_simple_key_and_value"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(2);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "write_simple_key_and_value"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", 1, "ania", 2}), QueryAssert.Row.row((Object[])new Object[]{"piotr", 3, "kasia", 4})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesRawTable.class})
    public void testInsertRawTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("INSERT INTO %s.%s.%s VALUES ('jasio', 9223372036854775807, 2147483647, 32767, 127, 1234567890.123456789, true), ('piotr', -9223372036854775808, -2147483648, -32768, -128, -1234567890.123456789, false), ('hasan', 9223372036854775807, 2147483647, 32767, 127, 1234567890.123456789, true), ('kasia', -9223372036854775808, -2147483648, -32768, -128, -1234567890.123456789, false)", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_raw"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(4);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_raw"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"piotr", Long.MIN_VALUE, Integer.MIN_VALUE, Short.MIN_VALUE, -128, -1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{"hasan", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"kasia", Long.MIN_VALUE, Integer.MIN_VALUE, Short.MIN_VALUE, -128, -1.2345678901234567E9, false})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesCsvTable.class})
    public void testInsertCsvTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("INSERT INTO %s.%s.%s VALUES ('jasio', 9223372036854775807, 2147483647, 32767, 127, 1234567890.123456789, true), ('stasio', -9223372036854775808, -2147483648, -32768, -128, -1234567890.123456789, false), (null, null, null, null, null, null, null), ('krzysio', 9223372036854775807, 2147483647, 32767, 127, 1234567890.123456789, false), ('kasia', 9223372036854775807, 2147483647, 32767, null, null, null)", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_csv"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(5);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT * FROM %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_csv"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"jasio", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true}), QueryAssert.Row.row((Object[])new Object[]{"stasio", Long.MIN_VALUE, Integer.MIN_VALUE, Short.MIN_VALUE, -128, -1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"krzysio", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, false}), QueryAssert.Row.row((Object[])new Object[]{"kasia", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, null, null, null})});
    }

    @Test(groups={"kafka", "profile_specific_tests"})
    @Requires(value={AllDataTypesJsonTable.class})
    public void testInsertJsonTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("INSERT INTO %s.%s.%s VALUES ('ala ma kota',9223372036854775807,2147483647,32767,127,1234567890.123456789,true,TIMESTAMP '2018-02-09 13:15:16',TIMESTAMP '2018-02-09 13:15:17',TIMESTAMP '2018-02-09 13:15:18',TIMESTAMP '2018-02-09 13:15:19',TIMESTAMP '2018-02-09 13:15:20',DATE '2018-02-11',DATE '2018-02-13',TIME '13:15:16',TIME '13:15:17',TIME '13:15:18',TIME '13:15:20',TIMESTAMP '2018-02-09 13:15:18 Pacific/Apia',TIMESTAMP '2018-02-09 13:15:19 Pacific/Apia',TIMESTAMP '2018-02-09 13:15:20 Pacific/Apia',TIMESTAMP '2018-02-09 13:15:21 Pacific/Apia',TIME '02:15:18 -11:00',TIME '02:15:20 -11:00')", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_json"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).updatedRowsCountIsEqualTo(1);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)String.format("SELECT c_varchar, c_bigint, c_integer, c_smallint, c_tinyint, c_double, c_boolean, c_timestamp_milliseconds_since_epoch, c_timestamp_seconds_since_epoch, c_timestamp_iso8601, c_timestamp_rfc2822, c_timestamp_custom, c_date_iso8601, c_date_custom, c_time_milliseconds_since_epoch, c_time_seconds_since_epoch, c_time_iso8601, c_time_custom, CAST(c_timestamptz_iso8601 AS VARCHAR), CAST(c_timestamptz_rfc2822 AS VARCHAR), CAST(c_timestamptz_custom AS VARCHAR), CAST(c_timestamptz_custom_with_zone AS VARCHAR), CAST(c_timetz_iso8601 AS VARCHAR), CAST(c_timetz_custom AS VARCHAR) FROM %s.%s.%s", KAFKA_CATALOG, SCHEMA_NAME, "write_all_datatypes_json"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ala ma kota", Long.MAX_VALUE, Integer.MAX_VALUE, Short.MAX_VALUE, 127, 1.2345678901234567E9, true, Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 16)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 17)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 18)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 19)), Timestamp.valueOf(LocalDateTime.of(2018, 2, 9, 13, 15, 20)), Date.valueOf(LocalDate.of(2018, 2, 11)), Date.valueOf(LocalDate.of(2018, 2, 13)), Time.valueOf(LocalTime.of(13, 15, 16)), Time.valueOf(LocalTime.of(13, 15, 17)), Time.valueOf(LocalTime.of(13, 15, 18)), Time.valueOf(LocalTime.of(13, 15, 20)), "2018-02-09 13:15:18.000 +14:00", "2018-02-09 13:15:19.000 +14:00", "2018-02-09 13:15:20.000 Pacific/Apia", "2018-02-09 13:15:21.000 Pacific/Apia", "02:15:18.000-11:00", "02:15:20.000-11:00"})});
    }

    private static class AllDataTypesJsonTable
    implements RequirementsProvider {
        private AllDataTypesJsonTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.write_all_datatypes_json", "write_all_datatypes_json", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }

    private static class AllDataTypesCsvTable
    implements RequirementsProvider {
        private AllDataTypesCsvTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.write_all_datatypes_csv", "write_all_datatypes_csv", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }

    private static class AllDataTypesRawTable
    implements RequirementsProvider {
        private AllDataTypesRawTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.write_all_datatypes_raw", "write_all_datatypes_raw", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }

    private static class SimpleKeyAndValueTable
    implements RequirementsProvider {
        private SimpleKeyAndValueTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)new KafkaTableDefinition("product_tests.write_simple_key_and_value", "write_simple_key_and_value", (KafkaDataSource)new ListKafkaDataSource((List)ImmutableList.of()), 1, 1));
        }
    }
}

