/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.prestosql.plugin.raptor.legacy.NodeSupplier;
import io.prestosql.plugin.raptor.legacy.RaptorConnector;
import io.prestosql.plugin.raptor.legacy.RaptorConnectorId;
import io.prestosql.plugin.raptor.legacy.RaptorHandleResolver;
import io.prestosql.plugin.raptor.legacy.RaptorMetadataFactory;
import io.prestosql.plugin.raptor.legacy.RaptorNodePartitioningProvider;
import io.prestosql.plugin.raptor.legacy.RaptorPageSinkProvider;
import io.prestosql.plugin.raptor.legacy.RaptorPageSourceProvider;
import io.prestosql.plugin.raptor.legacy.RaptorSessionProperties;
import io.prestosql.plugin.raptor.legacy.RaptorSplitManager;
import io.prestosql.plugin.raptor.legacy.RaptorTableProperties;
import io.prestosql.plugin.raptor.legacy.metadata.Distribution;
import io.prestosql.plugin.raptor.legacy.metadata.ForMetadata;
import io.prestosql.plugin.raptor.legacy.metadata.SchemaDaoUtil;
import io.prestosql.plugin.raptor.legacy.metadata.TableColumn;
import io.prestosql.plugin.raptor.legacy.systemtables.ShardMetadataSystemTable;
import io.prestosql.plugin.raptor.legacy.systemtables.TableMetadataSystemTable;
import io.prestosql.plugin.raptor.legacy.systemtables.TableStatsSystemTable;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Singleton;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.ConnectionFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class RaptorModule
implements Module {
    private final String connectorId;

    public RaptorModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        binder.bind(RaptorConnectorId.class).toInstance((Object)new RaptorConnectorId(this.connectorId));
        binder.bind(RaptorConnector.class).in(Scopes.SINGLETON);
        binder.bind(RaptorMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(RaptorSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(RaptorPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorHandleResolver.class).in(Scopes.SINGLETON);
        binder.bind(RaptorNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(RaptorSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(RaptorTableProperties.class).in(Scopes.SINGLETON);
        Multibinder tableBinder = Multibinder.newSetBinder((Binder)binder, SystemTable.class);
        tableBinder.addBinding().to(ShardMetadataSystemTable.class).in(Scopes.SINGLETON);
        tableBinder.addBinding().to(TableMetadataSystemTable.class).in(Scopes.SINGLETON);
        tableBinder.addBinding().to(TableStatsSystemTable.class).in(Scopes.SINGLETON);
    }

    @ForMetadata
    @Singleton
    @Provides
    public IDBI createDBI(@ForMetadata ConnectionFactory connectionFactory, TypeManager typeManager) {
        DBI dbi = new DBI(connectionFactory);
        dbi.registerMapper((ResultSetMapper)new TableColumn.Mapper(typeManager));
        dbi.registerMapper((ResultSetMapper)new Distribution.Mapper(typeManager));
        SchemaDaoUtil.createTablesWithRetry((IDBI)dbi);
        return dbi;
    }

    @Provides
    @Singleton
    public static NodeSupplier createNodeSupplier(NodeManager nodeManager) {
        return () -> ((NodeManager)nodeManager).getWorkerNodes();
    }
}

