/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import io.airlift.units.DataSize;
import io.prestosql.plugin.raptor.legacy.RaptorColumnHandle;
import io.prestosql.plugin.raptor.legacy.RaptorInsertTableHandle;
import io.prestosql.plugin.raptor.legacy.RaptorOutputTableHandle;
import io.prestosql.plugin.raptor.legacy.RaptorPageSink;
import io.prestosql.plugin.raptor.legacy.storage.StorageManager;
import io.prestosql.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.prestosql.plugin.raptor.legacy.storage.organization.TemporalFunction;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final StorageManager storageManager;
    private final PageSorter pageSorter;
    private final TemporalFunction temporalFunction;
    private final DataSize maxBufferSize;

    @Inject
    public RaptorPageSinkProvider(StorageManager storageManager, PageSorter pageSorter, TemporalFunction temporalFunction, StorageManagerConfig config) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.temporalFunction = Objects.requireNonNull(temporalFunction, "temporalFunction is null");
        this.maxBufferSize = config.getMaxBufferSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        RaptorOutputTableHandle handle = (RaptorOutputTableHandle)tableHandle;
        return new RaptorPageSink(this.pageSorter, this.storageManager, this.temporalFunction, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), this.maxBufferSize);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        RaptorInsertTableHandle handle = (RaptorInsertTableHandle)tableHandle;
        return new RaptorPageSink(this.pageSorter, this.storageManager, this.temporalFunction, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), this.maxBufferSize);
    }

    private static List<Long> toColumnIds(List<RaptorColumnHandle> columnHandles) {
        return columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
    }
}

