/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.concurrent.Threads;
import io.prestosql.plugin.raptor.legacy.NodeSupplier;
import io.prestosql.plugin.raptor.legacy.RaptorColumnHandle;
import io.prestosql.plugin.raptor.legacy.RaptorConnectorId;
import io.prestosql.plugin.raptor.legacy.RaptorErrorCode;
import io.prestosql.plugin.raptor.legacy.RaptorPartitioningHandle;
import io.prestosql.plugin.raptor.legacy.RaptorSessionProperties;
import io.prestosql.plugin.raptor.legacy.RaptorSplit;
import io.prestosql.plugin.raptor.legacy.RaptorTableHandle;
import io.prestosql.plugin.raptor.legacy.RaptorTableLayoutHandle;
import io.prestosql.plugin.raptor.legacy.backup.BackupService;
import io.prestosql.plugin.raptor.legacy.metadata.BucketShards;
import io.prestosql.plugin.raptor.legacy.metadata.ShardManager;
import io.prestosql.plugin.raptor.legacy.metadata.ShardNodes;
import io.prestosql.plugin.raptor.legacy.util.SynchronizedResultIterator;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.Node;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.skife.jdbi.v2.ResultIterator;

public class RaptorSplitManager
implements ConnectorSplitManager {
    private final NodeSupplier nodeSupplier;
    private final ShardManager shardManager;
    private final boolean backupAvailable;
    private final ExecutorService executor;

    @Inject
    public RaptorSplitManager(RaptorConnectorId connectorId, NodeSupplier nodeSupplier, ShardManager shardManager, BackupService backupService) {
        this(connectorId, nodeSupplier, shardManager, Objects.requireNonNull(backupService, "backupService is null").isBackupAvailable());
    }

    public RaptorSplitManager(RaptorConnectorId connectorId, NodeSupplier nodeSupplier, ShardManager shardManager, boolean backupAvailable) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.backupAvailable = backupAvailable;
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("raptor-split-" + connectorId + "-%s")));
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        RaptorTableLayoutHandle handle = (RaptorTableLayoutHandle)layout;
        RaptorTableHandle table = handle.getTable();
        TupleDomain<RaptorColumnHandle> effectivePredicate = RaptorSplitManager.toRaptorTupleDomain(handle.getConstraint());
        long tableId = table.getTableId();
        boolean bucketed = table.getBucketCount().isPresent();
        boolean merged = bucketed && !table.isDelete() && table.getBucketCount().getAsInt() >= RaptorSessionProperties.getOneSplitPerBucketThreshold(session);
        OptionalLong transactionId = table.getTransactionId();
        Optional<List<String>> bucketToNode = handle.getPartitioning().map(RaptorPartitioningHandle::getBucketToNode);
        Verify.verify((bucketed == bucketToNode.isPresent() ? 1 : 0) != 0, (String)"mismatched bucketCount and bucketToNode presence", (Object[])new Object[0]);
        return new RaptorSplitSource(tableId, merged, effectivePredicate, transactionId, bucketToNode);
    }

    private static List<HostAddress> getAddressesForNodes(Map<String, Node> nodeMap, Iterable<String> nodeIdentifiers) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (String id : nodeIdentifiers) {
            Node node = nodeMap.get(id);
            if (node == null) continue;
            nodes.add((Object)node.getHostAndPort());
        }
        return nodes.build();
    }

    private static TupleDomain<RaptorColumnHandle> toRaptorTupleDomain(TupleDomain<ColumnHandle> tupleDomain) {
        return tupleDomain.transform(handle -> (RaptorColumnHandle)handle);
    }

    private static <T> T selectRandom(Iterable<T> elements) {
        ImmutableList list = ImmutableList.copyOf(elements);
        return (T)list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    private class RaptorSplitSource
    implements ConnectorSplitSource {
        private final Map<String, Node> nodesById;
        private final long tableId;
        private final TupleDomain<RaptorColumnHandle> effectivePredicate;
        private final OptionalLong transactionId;
        private final Optional<List<String>> bucketToNode;
        private final ResultIterator<BucketShards> iterator;
        @GuardedBy(value="this")
        private CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> future;

        public RaptorSplitSource(long tableId, boolean merged, TupleDomain<RaptorColumnHandle> effectivePredicate, OptionalLong transactionId, Optional<List<String>> bucketToNode) {
            this.nodesById = Maps.uniqueIndex(RaptorSplitManager.this.nodeSupplier.getWorkerNodes(), Node::getNodeIdentifier);
            this.tableId = tableId;
            this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
            this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
            this.bucketToNode = Objects.requireNonNull(bucketToNode, "bucketToNode is null");
            ResultIterator<BucketShards> iterator = bucketToNode.isPresent() ? RaptorSplitManager.this.shardManager.getShardNodesBucketed(tableId, merged, bucketToNode.get(), effectivePredicate) : RaptorSplitManager.this.shardManager.getShardNodes(tableId, effectivePredicate);
            this.iterator = new SynchronizedResultIterator<BucketShards>(iterator);
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
            Preconditions.checkState((this.future == null || this.future.isDone() ? 1 : 0) != 0, (Object)"previous batch not completed");
            this.future = CompletableFuture.supplyAsync(this.batchSupplier(maxSize), RaptorSplitManager.this.executor);
            return this.future;
        }

        public synchronized void close() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            RaptorSplitManager.this.executor.execute(() -> this.iterator.close());
        }

        public boolean isFinished() {
            return !this.iterator.hasNext();
        }

        private Supplier<ConnectorSplitSource.ConnectorSplitBatch> batchSupplier(int maxSize) {
            return () -> {
                ImmutableList.Builder list = ImmutableList.builder();
                for (int i = 0; i < maxSize; ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new RuntimeException("Split batch fetch was interrupted");
                    }
                    if (!this.iterator.hasNext()) break;
                    list.add((Object)this.createSplit((BucketShards)this.iterator.next()));
                }
                return new ConnectorSplitSource.ConnectorSplitBatch((List)list.build(), this.isFinished());
            };
        }

        private ConnectorSplit createSplit(BucketShards bucketShards) {
            if (bucketShards.getBucketNumber().isPresent()) {
                return this.createBucketSplit(bucketShards.getBucketNumber().getAsInt(), bucketShards.getShards());
            }
            Verify.verify((bucketShards.getShards().size() == 1 ? 1 : 0) != 0, (String)"wrong shard count for non-bucketed table", (Object[])new Object[0]);
            ShardNodes shard = (ShardNodes)Iterables.getOnlyElement(bucketShards.getShards());
            UUID shardId = shard.getShardUuid();
            Set<String> nodeIds = shard.getNodeIdentifiers();
            List addresses = RaptorSplitManager.getAddressesForNodes(this.nodesById, nodeIds);
            if (addresses.isEmpty()) {
                if (!RaptorSplitManager.this.backupAvailable) {
                    throw new PrestoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_NO_HOST_FOR_SHARD, String.format("No host for shard %s found: %s", shardId, nodeIds));
                }
                Set<Node> availableNodes = RaptorSplitManager.this.nodeSupplier.getWorkerNodes();
                if (availableNodes.isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                Node node = (Node)RaptorSplitManager.selectRandom(availableNodes);
                RaptorSplitManager.this.shardManager.replaceShardAssignment(this.tableId, shardId, node.getNodeIdentifier(), true);
                addresses = ImmutableList.of((Object)node.getHostAndPort());
            }
            return new RaptorSplit(shardId, addresses, this.effectivePredicate, this.transactionId);
        }

        private ConnectorSplit createBucketSplit(int bucketNumber, Set<ShardNodes> shards) {
            String nodeId = this.bucketToNode.get().get(bucketNumber);
            Node node = this.nodesById.get(nodeId);
            if (node == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "Node for bucket is offline: " + nodeId);
            }
            Set<UUID> shardUuids = shards.stream().map(ShardNodes::getShardUuid).collect(Collectors.toSet());
            HostAddress address = node.getHostAndPort();
            return new RaptorSplit(shardUuids, bucketNumber, address, this.effectivePredicate, this.transactionId);
        }
    }
}

