/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.prestosql.plugin.raptor.legacy.util.MetadataUtil;
import io.prestosql.spi.connector.ConnectorTableHandle;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class RaptorTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final long tableId;
    private final OptionalLong distributionId;
    private final Optional<String> distributionName;
    private final OptionalInt bucketCount;
    private final boolean organized;
    private final OptionalLong transactionId;
    private final boolean delete;

    @JsonCreator
    public RaptorTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableId") long tableId, @JsonProperty(value="distributionId") OptionalLong distributionId, @JsonProperty(value="distributionName") Optional<String> distributionName, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="organized") boolean organized, @JsonProperty(value="transactionId") OptionalLong transactionId, @JsonProperty(value="delete") boolean delete) {
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        Preconditions.checkArgument((tableId > 0L ? 1 : 0) != 0, (Object)"tableId must be greater than zero");
        this.tableId = tableId;
        this.distributionName = Objects.requireNonNull(distributionName, "distributionName is null");
        this.distributionId = Objects.requireNonNull(distributionId, "distributionId is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.organized = organized;
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.delete = delete;
    }

    public boolean isBucketed() {
        return this.distributionId.isPresent();
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public long getTableId() {
        return this.tableId;
    }

    @JsonProperty
    public OptionalLong getDistributionId() {
        return this.distributionId;
    }

    @JsonProperty
    public Optional<String> getDistributionName() {
        return this.distributionName;
    }

    @JsonProperty
    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public boolean isOrganized() {
        return this.organized;
    }

    @JsonProperty
    public OptionalLong getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public boolean isDelete() {
        return this.delete;
    }

    public String toString() {
        return this.schemaName + ":" + this.tableName + ":" + this.tableId;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.tableId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RaptorTableHandle other = (RaptorTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.tableId, other.tableId);
    }
}

