/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.backup;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import io.prestosql.plugin.raptor.legacy.RaptorErrorCode;
import io.prestosql.spi.PrestoException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class BackupOperationStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat successes = new CounterStat();
    private final CounterStat failures = new CounterStat();
    private final CounterStat timeouts = new CounterStat();

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    @Managed
    @Nested
    public CounterStat getSuccesses() {
        return this.successes;
    }

    @Managed
    @Nested
    public CounterStat getFailures() {
        return this.failures;
    }

    @Managed
    @Nested
    public CounterStat getTimeouts() {
        return this.timeouts;
    }

    public void run(Runnable runnable) {
        this.run(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <V> V run(Supplier<V> supplier) {
        try (TimeStat.BlockTimer ignored = this.time.time();){
            V value = supplier.get();
            this.successes.update(1L);
            V v = value;
            return v;
        }
        catch (PrestoException e) {
            if (e.getErrorCode().equals((Object)RaptorErrorCode.RAPTOR_BACKUP_NOT_FOUND.toErrorCode())) {
                this.successes.update(1L);
                throw e;
            }
            if (e.getErrorCode().equals((Object)RaptorErrorCode.RAPTOR_BACKUP_TIMEOUT.toErrorCode())) {
                this.timeouts.update(1L);
                throw e;
            }
            this.failures.update(1L);
            throw e;
        }
    }
}

