/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.prestosql.plugin.raptor.legacy.metadata.ShardDao;
import io.prestosql.plugin.raptor.legacy.util.UuidUtil;
import java.sql.Timestamp;
import java.util.UUID;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterArgumentFactory;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapperFactory;

@RegisterArgumentFactory(value={UuidUtil.UuidArgumentFactory.class})
@RegisterMapperFactory(value={UuidUtil.UuidMapperFactory.class})
public interface H2ShardDao
extends ShardDao {
    @Override
    @SqlBatch(value="MERGE INTO deleted_shards (shard_uuid, delete_time)\nVALUES (:shardUuid, CURRENT_TIMESTAMP)")
    public void insertDeletedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    @Override
    @SqlUpdate(value="DELETE FROM transactions\nWHERE end_time < :maxEndTime\n  AND successful IN (TRUE, FALSE)\n  AND transaction_id NOT IN (SELECT transaction_id FROM created_shards)\nLIMIT 10000")
    public int deleteOldCompletedTransactions(@Bind(value="maxEndTime") Timestamp var1);
}

