/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

public class MetadataConfig {
    private Duration startupGracePeriod = new Duration(5.0, TimeUnit.MINUTES);
    private Duration reassignmentDelay = new Duration(0.0, TimeUnit.MINUTES);
    private Duration reassignmentInterval = new Duration(0.0, TimeUnit.MINUTES);

    @NotNull
    public Duration getStartupGracePeriod() {
        return this.startupGracePeriod;
    }

    @Config(value="raptor.startup-grace-period")
    @ConfigDescription(value="Minimum uptime before allowing bucket or shard reassignments")
    public MetadataConfig setStartupGracePeriod(Duration startupGracePeriod) {
        this.startupGracePeriod = startupGracePeriod;
        return this;
    }

    @NotNull
    public Duration getReassignmentDelay() {
        return this.reassignmentDelay;
    }

    @Config(value="raptor.reassignment-delay")
    @ConfigDescription(value="Minimum delay before allowing reassignments for a node")
    public MetadataConfig setReassignmentDelay(Duration reassignmentDelay) {
        this.reassignmentDelay = reassignmentDelay;
        return this;
    }

    @NotNull
    public Duration getReassignmentInterval() {
        return this.reassignmentInterval;
    }

    @Config(value="raptor.reassignment-interval")
    @ConfigDescription(value="Minimum interval between reassignments for different nodes")
    public MetadataConfig setReassignmentInterval(Duration reassignmentInterval) {
        this.reassignmentInterval = reassignmentInterval;
        return this;
    }
}

