/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import io.prestosql.plugin.raptor.legacy.metadata.ColumnMetadataRow;
import io.prestosql.plugin.raptor.legacy.metadata.Distribution;
import io.prestosql.plugin.raptor.legacy.metadata.SchemaTableNameMapper;
import io.prestosql.plugin.raptor.legacy.metadata.Table;
import io.prestosql.plugin.raptor.legacy.metadata.TableColumn;
import io.prestosql.plugin.raptor.legacy.metadata.TableMetadataRow;
import io.prestosql.plugin.raptor.legacy.metadata.TableStatsRow;
import io.prestosql.plugin.raptor.legacy.metadata.ViewResult;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Set;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Mapper;

public interface MetadataDao {
    public static final String TABLE_INFORMATION_SELECT = "SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\n";
    public static final String TABLE_COLUMN_SELECT = "SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\n";

    @SqlQuery(value="SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\nWHERE t.table_id = :tableId")
    @Mapper(value=Table.TableMapper.class)
    public Table getTableInformation(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT t.table_id, t.distribution_id, d.distribution_name, d.bucket_count, t.temporal_column_id, t.organization_enabled\nFROM tables t\nLEFT JOIN distributions d ON (t.distribution_id = d.distribution_id)\nWHERE t.schema_name = :schemaName\n  AND t.table_name = :tableName")
    @Mapper(value=Table.TableMapper.class)
    public Table getTableInformation(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.column_id = :columnId\nORDER BY c.ordinal_position\n")
    public TableColumn getTableColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3);

    @SqlQuery(value="SELECT schema_name, table_name\nFROM tables\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    @Mapper(value=SchemaTableNameMapper.class)
    public List<SchemaTableName> listTables(@Bind(value="schemaName") String var1);

    @SqlQuery(value="SELECT DISTINCT schema_name FROM tables")
    public List<String> listSchemaNames();

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name, ordinal_position")
    public List<TableColumn> listTableColumns(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\nORDER BY c.ordinal_position")
    public List<TableColumn> listTableColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.sort_ordinal_position IS NOT NULL\nORDER BY c.sort_ordinal_position")
    public List<TableColumn> listSortColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT t.schema_name, t.table_name,\n  c.column_id, c.column_name, c.data_type, c.ordinal_position,\n  c.bucket_ordinal_position, c.sort_ordinal_position,\n  t.temporal_column_id = c.column_id AS temporal\nFROM tables t\nJOIN columns c ON (t.table_id = c.table_id)\nWHERE t.table_id = :tableId\n  AND c.bucket_ordinal_position IS NOT NULL\nORDER BY c.bucket_ordinal_position")
    public List<TableColumn> listBucketColumns(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)")
    @Mapper(value=SchemaTableNameMapper.class)
    public List<SchemaTableName> listViews(@Bind(value="schemaName") String var1);

    @SqlQuery(value="SELECT schema_name, table_name, data\nFROM views\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name\n")
    @Mapper(value=ViewResult.Mapper.class)
    public List<ViewResult> getViews(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlUpdate(value="INSERT INTO tables (\n  schema_name, table_name, compaction_enabled, organization_enabled, distribution_id,\n  create_time, update_time, table_version,\n  shard_count, row_count, compressed_size, uncompressed_size)\nVALUES (\n  :schemaName, :tableName, :compactionEnabled, :organizationEnabled, :distributionId,\n  :createTime, :createTime, 0,\n  0, 0, 0, 0)\n")
    @GetGeneratedKeys
    public long insertTable(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2, @Bind(value="compactionEnabled") boolean var3, @Bind(value="organizationEnabled") boolean var4, @Bind(value="distributionId") Long var5, @Bind(value="createTime") long var6);

    @SqlUpdate(value="UPDATE tables SET\n  update_time = :updateTime\n, table_version = table_version + 1\nWHERE table_id = :tableId")
    public void updateTableVersion(@Bind(value="tableId") long var1, @Bind(value="updateTime") long var3);

    @SqlUpdate(value="UPDATE tables SET\n  shard_count = shard_count + :shardCount \n, row_count = row_count + :rowCount\n, compressed_size = compressed_size + :compressedSize\n, uncompressed_size = uncompressed_size + :uncompressedSize\nWHERE table_id = :tableId")
    public void updateTableStats(@Bind(value="tableId") long var1, @Bind(value="shardCount") long var3, @Bind(value="rowCount") long var5, @Bind(value="compressedSize") long var7, @Bind(value="uncompressedSize") long var9);

    @SqlUpdate(value="INSERT INTO columns (table_id, column_id, column_name, ordinal_position, data_type, sort_ordinal_position, bucket_ordinal_position)\nVALUES (:tableId, :columnId, :columnName, :ordinalPosition, :dataType, :sortOrdinalPosition, :bucketOrdinalPosition)")
    public void insertColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3, @Bind(value="columnName") String var5, @Bind(value="ordinalPosition") int var6, @Bind(value="dataType") String var7, @Bind(value="sortOrdinalPosition") Integer var8, @Bind(value="bucketOrdinalPosition") Integer var9);

    @SqlUpdate(value="UPDATE tables SET\n  schema_name = :newSchemaName\n, table_name = :newTableName\nWHERE table_id = :tableId")
    public void renameTable(@Bind(value="tableId") long var1, @Bind(value="newSchemaName") String var3, @Bind(value="newTableName") String var4);

    @SqlUpdate(value="UPDATE columns SET column_name = :target\nWHERE table_id = :tableId\n  AND column_id = :columnId")
    public void renameColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3, @Bind(value="target") String var5);

    @SqlUpdate(value="DELETE FROM columns\n WHERE table_id = :tableId\n  AND column_id = :columnId")
    public void dropColumn(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3);

    @SqlUpdate(value="INSERT INTO views (schema_name, table_name, data)\nVALUES (:schemaName, :tableName, :data)")
    public void insertView(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2, @Bind(value="data") String var3);

    @SqlUpdate(value="DELETE FROM tables WHERE table_id = :tableId")
    public int dropTable(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM columns WHERE table_id = :tableId")
    public int dropColumns(@Bind(value="tableId") long var1);

    @SqlUpdate(value="DELETE FROM views\nWHERE schema_name = :schemaName\n  AND table_name = :tableName")
    public int dropView(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT temporal_column_id\nFROM tables\nWHERE table_id = :tableId\n  AND temporal_column_id IS NOT NULL")
    public Long getTemporalColumnId(@Bind(value="tableId") long var1);

    @SqlUpdate(value="UPDATE tables SET\ntemporal_column_id = :columnId\nWHERE table_id = :tableId")
    public void updateTemporalColumnId(@Bind(value="tableId") long var1, @Bind(value="columnId") long var3);

    @SqlQuery(value="SELECT compaction_enabled AND maintenance_blocked IS NULL\nFROM tables\nWHERE table_id = :tableId")
    public boolean isCompactionEligible(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT table_id FROM tables WHERE table_id = :tableId FOR UPDATE")
    public Long getLockedTableId(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_id = :distributionId")
    public Distribution getDistribution(@Bind(value="distributionId") long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_name = :distributionName")
    public Distribution getDistribution(@Bind(value="distributionName") String var1);

    @SqlUpdate(value="INSERT INTO distributions (distribution_name, column_types, bucket_count)\nVALUES (:distributionName, :columnTypes, :bucketCount)")
    @GetGeneratedKeys
    public long insertDistribution(@Bind(value="distributionName") String var1, @Bind(value="columnTypes") String var2, @Bind(value="bucketCount") int var3);

    @SqlQuery(value="SELECT table_id, schema_name, table_name, temporal_column_id, distribution_name, bucket_count, organization_enabled\nFROM tables\nLEFT JOIN distributions\nON tables.distribution_id = distributions.distribution_id\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY table_id")
    @Mapper(value=TableMetadataRow.Mapper.class)
    public List<TableMetadataRow> getTableMetadataRows(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT table_id, column_id, column_name, sort_ordinal_position, bucket_ordinal_position\nFROM columns\nWHERE table_id IN (\n  SELECT table_id\n  FROM tables\n  WHERE (schema_name = :schemaName OR :schemaName IS NULL)\n    AND (table_name = :tableName OR :tableName IS NULL))\nORDER BY table_id")
    @Mapper(value=ColumnMetadataRow.Mapper.class)
    public List<ColumnMetadataRow> getColumnMetadataRows(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT schema_name, table_name, create_time, update_time, table_version,\n  shard_count, row_count, compressed_size, uncompressed_size\nFROM tables\nWHERE (schema_name = :schemaName OR :schemaName IS NULL)\n  AND (table_name = :tableName OR :tableName IS NULL)\nORDER BY schema_name, table_name")
    @Mapper(value=TableStatsRow.Mapper.class)
    public List<TableStatsRow> getTableStatsRows(@Bind(value="schemaName") String var1, @Bind(value="tableName") String var2);

    @SqlQuery(value="SELECT table_id\nFROM tables\nWHERE organization_enabled\n  AND maintenance_blocked IS NULL\n  AND table_id IN\n       (SELECT table_id\n        FROM columns\n        WHERE sort_ordinal_position IS NOT NULL)")
    public Set<Long> getOrganizationEligibleTables();

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = CURRENT_TIMESTAMP\nWHERE table_id = :tableId\n  AND maintenance_blocked IS NULL")
    public void blockMaintenance(@Bind(value="tableId") long var1);

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = NULL\nWHERE table_id = :tableId")
    public void unblockMaintenance(@Bind(value="tableId") long var1);

    @SqlQuery(value="SELECT maintenance_blocked IS NOT NULL\nFROM tables\nWHERE table_id = :tableId\nFOR UPDATE")
    public boolean isMaintenanceBlockedLocked(@Bind(value="tableId") long var1);

    @SqlUpdate(value="UPDATE tables SET maintenance_blocked = NULL\nWHERE maintenance_blocked IS NOT NULL")
    public void unblockAllMaintenance();
}

