/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.raptor.legacy.metadata.ColumnInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class TableMetadata {
    private final long tableId;
    private final List<ColumnInfo> columns;
    private final List<Long> sortColumnIds;

    public TableMetadata(long tableId, List<ColumnInfo> columns, List<Long> sortColumnIds) {
        this.tableId = tableId;
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.sortColumnIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortColumnIds, "sortColumnIds is null"));
    }

    public long getTableId() {
        return this.tableId;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public List<Long> getSortColumnIds() {
        return this.sortColumnIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetadata that = (TableMetadata)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.columns, that.columns) && Objects.equals(this.sortColumnIds, that.sortColumnIds);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.columns, this.sortColumnIds);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("columns", this.columns).add("sortColumnIds", this.sortColumnIds).toString();
    }
}

