/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TableStatsRow {
    private final String schemaName;
    private final String tableName;
    private final long createTime;
    private final long updateTime;
    private final long tableVersion;
    private final long shardCount;
    private final long rowCount;
    private final long compressedSize;
    private final long uncompressedSize;

    public TableStatsRow(String schemaName, String tableName, long createTime, long updateTime, long tableVersion, long shardCount, long rowCount, long compressedSize, long uncompressedSize) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.tableVersion = tableVersion;
        this.shardCount = shardCount;
        this.rowCount = rowCount;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public long getTableVersion() {
        return this.tableVersion;
    }

    public long getShardCount() {
        return this.shardCount;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public static class Mapper
    implements ResultSetMapper<TableStatsRow> {
        public TableStatsRow map(int index, ResultSet rs, StatementContext context) throws SQLException {
            return new TableStatsRow(rs.getString("schema_name"), rs.getString("table_name"), rs.getLong("create_time"), rs.getLong("update_time"), rs.getLong("table_version"), rs.getLong("shard_count"), rs.getLong("row_count"), rs.getLong("compressed_size"), rs.getLong("uncompressed_size"));
        }
    }
}

