/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.security;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.prestosql.plugin.base.security.AllowAllAccessControlModule;
import io.prestosql.plugin.base.security.FileBasedAccessControlModule;
import io.prestosql.plugin.base.security.ReadOnlySecurityModule;
import io.prestosql.plugin.raptor.legacy.security.RaptorSecurityConfig;

public class RaptorSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.bindSecurityModule("none", (Module)new AllowAllAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(RaptorSecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), (Module)module));
    }
}

