/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage;

import java.util.Objects;

public final class StorageType {
    public static final StorageType BOOLEAN = new StorageType("boolean");
    public static final StorageType LONG = new StorageType("bigint");
    public static final StorageType DOUBLE = new StorageType("double");
    public static final StorageType STRING = new StorageType("string");
    public static final StorageType BYTES = new StorageType("binary");
    private final String hiveTypeName;

    public static StorageType arrayOf(StorageType elementStorageType) {
        return new StorageType(String.format("%s<%s>", "array", elementStorageType.getHiveTypeName()));
    }

    public static StorageType mapOf(StorageType keyStorageType, StorageType valueStorageType) {
        return new StorageType(String.format("%s<%s,%s>", "map", keyStorageType.getHiveTypeName(), valueStorageType.getHiveTypeName()));
    }

    public static StorageType decimal(int precision, int scale) {
        return new StorageType(String.format("%s(%d,%d)", "decimal", precision, scale));
    }

    private StorageType(String hiveTypeName) {
        this.hiveTypeName = Objects.requireNonNull(hiveTypeName, "hiveTypeName is null");
    }

    public String getHiveTypeName() {
        return this.hiveTypeName;
    }
}

