/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;

public class OrganizationSet {
    private final long tableId;
    private final Set<UUID> shards;
    private final OptionalInt bucketNumber;

    public OrganizationSet(long tableId, Set<UUID> shards, OptionalInt bucketNumber) {
        this.tableId = tableId;
        this.shards = Objects.requireNonNull(shards, "shards is null");
        this.bucketNumber = Objects.requireNonNull(bucketNumber, "bucketNumber is null");
    }

    public long getTableId() {
        return this.tableId;
    }

    public Set<UUID> getShards() {
        return this.shards;
    }

    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationSet that = (OrganizationSet)o;
        return this.tableId == that.tableId && Objects.equals(this.shards, that.shards) && Objects.equals(this.bucketNumber, that.bucketNumber);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.shards, this.bucketNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("shards", this.shards).add("bucketNumber", this.bucketNumber.isPresent() ? Integer.valueOf(this.bucketNumber.getAsInt()) : null).omitNullValues().toString();
    }
}

