/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.units.Duration;
import io.prestosql.plugin.raptor.legacy.RaptorColumnHandle;
import io.prestosql.plugin.raptor.legacy.metadata.ColumnInfo;
import io.prestosql.plugin.raptor.legacy.metadata.ShardInfo;
import io.prestosql.plugin.raptor.legacy.storage.ReaderAttributes;
import io.prestosql.plugin.raptor.legacy.storage.Row;
import io.prestosql.plugin.raptor.legacy.storage.StorageManager;
import io.prestosql.plugin.raptor.legacy.storage.StoragePageSink;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class ShardCompactor {
    private final StorageManager storageManager;
    private final CounterStat inputShards = new CounterStat();
    private final CounterStat outputShards = new CounterStat();
    private final DistributionStat inputShardsPerCompaction = new DistributionStat();
    private final DistributionStat outputShardsPerCompaction = new DistributionStat();
    private final DistributionStat compactionLatencyMillis = new DistributionStat();
    private final DistributionStat sortedCompactionLatencyMillis = new DistributionStat();
    private final ReaderAttributes readerAttributes;

    @Inject
    public ShardCompactor(StorageManager storageManager, ReaderAttributes readerAttributes) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.readerAttributes = Objects.requireNonNull(readerAttributes, "readerAttributes is null");
    }

    public List<ShardInfo> compact(long transactionId, OptionalInt bucketNumber, Set<UUID> uuids, List<ColumnInfo> columns) throws IOException {
        List<ShardInfo> shardInfos;
        long start = System.nanoTime();
        List<Long> columnIds = columns.stream().map(ColumnInfo::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().map(ColumnInfo::getType).collect(Collectors.toList());
        StoragePageSink storagePageSink = this.storageManager.createStoragePageSink(transactionId, bucketNumber, columnIds, columnTypes, false);
        try {
            shardInfos = this.compact(storagePageSink, bucketNumber, uuids, columnIds, columnTypes);
        }
        catch (IOException | RuntimeException e) {
            storagePageSink.rollback();
            throw e;
        }
        this.updateStats(uuids.size(), shardInfos.size(), Duration.nanosSince((long)start).toMillis());
        return shardInfos;
    }

    private List<ShardInfo> compact(StoragePageSink storagePageSink, OptionalInt bucketNumber, Set<UUID> uuids, List<Long> columnIds, List<Type> columnTypes) throws IOException {
        for (UUID uuid : uuids) {
            ConnectorPageSource pageSource = this.storageManager.getPageSource(uuid, bucketNumber, columnIds, columnTypes, (TupleDomain<RaptorColumnHandle>)TupleDomain.all(), this.readerAttributes);
            Throwable throwable = null;
            try {
                while (!pageSource.isFinished()) {
                    Page page = pageSource.getNextPage();
                    if (ShardCompactor.isNullOrEmptyPage(page)) continue;
                    storagePageSink.appendPages((List<Page>)ImmutableList.of((Object)page));
                    if (!storagePageSink.isFull()) continue;
                    storagePageSink.flush();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pageSource == null) continue;
                if (throwable != null) {
                    try {
                        pageSource.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pageSource.close();
            }
        }
        return (List)MoreFutures.getFutureValue(storagePageSink.commit());
    }

    public List<ShardInfo> compactSorted(long transactionId, OptionalInt bucketNumber, Set<UUID> uuids, List<ColumnInfo> columns, List<Long> sortColumnIds, List<SortOrder> sortOrders) throws IOException {
        Preconditions.checkArgument((sortColumnIds.size() == sortOrders.size() ? 1 : 0) != 0, (Object)"sortColumnIds and sortOrders must be of the same size");
        long start = System.nanoTime();
        List<Long> columnIds = columns.stream().map(ColumnInfo::getColumnId).collect(Collectors.toList());
        List<Type> columnTypes = columns.stream().map(ColumnInfo::getType).collect(Collectors.toList());
        Preconditions.checkArgument((boolean)columnIds.containsAll(sortColumnIds), (Object)"sortColumnIds must be a subset of columnIds");
        List<Integer> sortIndexes = sortColumnIds.stream().map(columnIds::indexOf).collect(Collectors.toList());
        PriorityQueue<SortedRowSource> rowSources = new PriorityQueue<SortedRowSource>();
        StoragePageSink outputPageSink = this.storageManager.createStoragePageSink(transactionId, bucketNumber, columnIds, columnTypes, false);
        try {
            for (UUID uuid : uuids) {
                ConnectorPageSource pageSource = this.storageManager.getPageSource(uuid, bucketNumber, columnIds, columnTypes, (TupleDomain<RaptorColumnHandle>)TupleDomain.all(), this.readerAttributes);
                SortedRowSource rowSource = new SortedRowSource(pageSource, columnTypes, sortIndexes, sortOrders);
                rowSources.add(rowSource);
            }
            while (!rowSources.isEmpty()) {
                SortedRowSource rowSource = (SortedRowSource)rowSources.poll();
                if (!rowSource.hasNext()) {
                    rowSource.close();
                    continue;
                }
                outputPageSink.appendRow(rowSource.next());
                if (outputPageSink.isFull()) {
                    outputPageSink.flush();
                }
                rowSources.add(rowSource);
            }
            outputPageSink.flush();
            List shardInfos = (List)MoreFutures.getFutureValue(outputPageSink.commit());
            this.updateStats(uuids.size(), shardInfos.size(), Duration.nanosSince((long)start).toMillis());
            List list = shardInfos;
            return list;
        }
        catch (IOException | RuntimeException e) {
            outputPageSink.rollback();
            throw e;
        }
        finally {
            rowSources.forEach(SortedRowSource::closeQuietly);
        }
    }

    private static boolean isNullOrEmptyPage(Page nextPage) {
        return nextPage == null || nextPage.getPositionCount() == 0;
    }

    private void updateStats(int inputShardsCount, int outputShardsCount, long latency) {
        this.inputShards.update((long)inputShardsCount);
        this.outputShards.update((long)outputShardsCount);
        this.inputShardsPerCompaction.add((long)inputShardsCount);
        this.outputShardsPerCompaction.add((long)outputShardsCount);
        this.compactionLatencyMillis.add(latency);
    }

    @Managed
    @Nested
    public CounterStat getInputShards() {
        return this.inputShards;
    }

    @Managed
    @Nested
    public CounterStat getOutputShards() {
        return this.outputShards;
    }

    @Managed
    @Nested
    public DistributionStat getInputShardsPerCompaction() {
        return this.inputShardsPerCompaction;
    }

    @Managed
    @Nested
    public DistributionStat getOutputShardsPerCompaction() {
        return this.outputShardsPerCompaction;
    }

    @Managed
    @Nested
    public DistributionStat getCompactionLatencyMillis() {
        return this.compactionLatencyMillis;
    }

    @Managed
    @Nested
    public DistributionStat getSortedCompactionLatencyMillis() {
        return this.sortedCompactionLatencyMillis;
    }

    private static class SortedRowSource
    implements Iterator<Row>,
    Comparable<SortedRowSource>,
    Closeable {
        private final ConnectorPageSource pageSource;
        private final List<Type> columnTypes;
        private final List<Integer> sortIndexes;
        private final List<SortOrder> sortOrders;
        private Page currentPage;
        private int currentPosition;

        public SortedRowSource(ConnectorPageSource pageSource, List<Type> columnTypes, List<Integer> sortIndexes, List<SortOrder> sortOrders) {
            this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
            this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
            this.sortIndexes = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortIndexes, "sortIndexes is null"));
            this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
            this.currentPage = pageSource.getNextPage();
            this.currentPosition = 0;
        }

        @Override
        public boolean hasNext() {
            if (SortedRowSource.hasMorePositions(this.currentPage, this.currentPosition)) {
                return true;
            }
            Page page = SortedRowSource.getNextPage(this.pageSource);
            if (ShardCompactor.isNullOrEmptyPage(page)) {
                return false;
            }
            this.currentPage = page.getLoadedPage();
            this.currentPosition = 0;
            return true;
        }

        private static Page getNextPage(ConnectorPageSource pageSource) {
            Page page = null;
            while (ShardCompactor.isNullOrEmptyPage(page) && !pageSource.isFinished()) {
                page = pageSource.getNextPage();
                if (page == null) continue;
                page = page.getLoadedPage();
            }
            return page;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row row = Row.extractRow(this.currentPage, this.currentPosition, this.columnTypes);
            ++this.currentPosition;
            return row;
        }

        @Override
        public int compareTo(SortedRowSource other) {
            if (!this.hasNext()) {
                return 1;
            }
            if (!other.hasNext()) {
                return -1;
            }
            for (int i = 0; i < this.sortIndexes.size(); ++i) {
                int channel = this.sortIndexes.get(i);
                Type type = this.columnTypes.get(channel);
                Block leftBlock = this.currentPage.getBlock(channel);
                int leftBlockPosition = this.currentPosition;
                Block rightBlock = other.currentPage.getBlock(channel);
                int rightBlockPosition = other.currentPosition;
                int compare = this.sortOrders.get(i).compareBlockValue(type, leftBlock, leftBlockPosition, rightBlock, rightBlockPosition);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }

        private static boolean hasMorePositions(Page currentPage, int currentPosition) {
            return currentPage != null && currentPosition < currentPage.getPositionCount();
        }

        void closeQuietly() {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            this.pageSource.close();
        }
    }
}

