/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import com.google.common.base.MoreObjects;
import io.prestosql.plugin.raptor.legacy.storage.organization.Tuple;
import java.util.Objects;

public class ShardRange {
    private final Tuple minTuple;
    private final Tuple maxTuple;

    public static ShardRange of(Tuple min, Tuple max) {
        return new ShardRange(min, max);
    }

    private ShardRange(Tuple minTuple, Tuple maxTuple) {
        this.minTuple = Objects.requireNonNull(minTuple, "minTuple is null");
        this.maxTuple = Objects.requireNonNull(maxTuple, "maxTuple is null");
    }

    public Tuple getMinTuple() {
        return this.minTuple;
    }

    public Tuple getMaxTuple() {
        return this.maxTuple;
    }

    public boolean encloses(ShardRange other) {
        return this.getMinTuple().compareTo(other.getMinTuple()) <= 0 && this.getMaxTuple().compareTo(other.getMaxTuple()) >= 0;
    }

    public boolean overlaps(ShardRange other) {
        return this.getMinTuple().compareTo(other.getMaxTuple()) <= 0 && other.getMinTuple().compareTo(this.getMaxTuple()) <= 0;
    }

    public boolean adjacent(ShardRange other) {
        Object o1Min = this.getMinTuple().getValues().get(0);
        Object o1Max = this.getMaxTuple().getValues().get(0);
        Object o2Min = other.getMinTuple().getValues().get(0);
        Object o2Max = other.getMaxTuple().getValues().get(0);
        return o1Max.equals(o2Min) || o2Max.equals(o1Min);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardRange that = (ShardRange)o;
        return Objects.equals(this.minTuple, that.minTuple) && Objects.equals(this.maxTuple, that.maxTuple);
    }

    public int hashCode() {
        return Objects.hash(this.minTuple, this.maxTuple);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minTuple", (Object)this.minTuple).add("maxTuple", (Object)this.maxTuple).toString();
    }
}

