/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.prestosql.plugin.raptor.legacy.storage.organization.ShardRange;
import io.prestosql.plugin.raptor.legacy.storage.organization.Tuple;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class TemporalFunction {
    private final DateTimeZone timeZone;

    @Inject
    public TemporalFunction(StorageManagerConfig config) {
        this(config.getShardDayBoundaryTimeZone());
    }

    public TemporalFunction(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public int getDay(Type type, Block block, int position) {
        if (type.equals(DateType.DATE)) {
            return Math.toIntExact(DateType.DATE.getLong(block, position));
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            long millis = TimestampType.TIMESTAMP.getLong(block, position);
            long local = this.timeZone.convertUTCToLocal(millis);
            long days = TimeUnit.MILLISECONDS.toDays(local);
            return Math.toIntExact(days);
        }
        throw new IllegalArgumentException("Wrong type for temporal column: " + type);
    }

    public int getDayFromRange(ShardRange range) {
        Tuple min = range.getMinTuple();
        Tuple max = range.getMaxTuple();
        Preconditions.checkArgument((boolean)((Type)Iterables.getOnlyElement(min.getTypes())).equals(Iterables.getOnlyElement(max.getTypes())), (Object)"type of min and max is not same");
        Type type = (Type)Iterables.getOnlyElement(min.getTypes());
        if (type.equals(DateType.DATE)) {
            return (Integer)Iterables.getOnlyElement(min.getValues());
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            long minValue = this.timeZone.convertUTCToLocal(((Long)Iterables.getOnlyElement(min.getValues())).longValue());
            long maxValue = this.timeZone.convertUTCToLocal(((Long)Iterables.getOnlyElement(max.getValues())).longValue());
            return TemporalFunction.determineDay(minValue, maxValue);
        }
        throw new IllegalArgumentException("Wrong type for shard range: " + type);
    }

    private static int determineDay(long rangeStart, long rangeEnd) {
        long millisInEndDay;
        int endDay;
        int startDay = Math.toIntExact(Duration.ofMillis(rangeStart).toDays());
        if (startDay == (endDay = Math.toIntExact(Duration.ofMillis(rangeEnd).toDays()))) {
            return Math.toIntExact(startDay);
        }
        if (endDay - startDay > 1) {
            return startDay + 1;
        }
        long millisInStartDay = Duration.ofDays(endDay).toMillis() - rangeStart;
        return millisInStartDay >= (millisInEndDay = rangeEnd - Duration.ofDays(endDay).toMillis()) ? startDay : endDay;
    }
}

