/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.storage.organization;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class Tuple
implements Comparable<Tuple> {
    private final List<Type> types;
    private final List<Object> values;

    public Tuple(Type type, Object value) {
        this((List<Type>)ImmutableList.of((Object)type), (List<Object>)ImmutableList.of((Object)value));
    }

    public Tuple(List<Type> types, Object ... values) {
        this(types, (List<Object>)ImmutableList.copyOf((Object[])values));
    }

    public Tuple(List<Type> types, List<Object> values) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.values = Objects.requireNonNull(values, "values is null");
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        Preconditions.checkArgument((types.size() == values.size() ? 1 : 0) != 0, (Object)"types and values must have the same number of elements");
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public int compareTo(Tuple o) {
        int i;
        Preconditions.checkArgument((o.getTypes().size() == this.types.size() ? 1 : 0) != 0, (Object)"types must be of same size");
        for (i = 0; i < this.types.size(); ++i) {
            Preconditions.checkArgument((boolean)o.getTypes().get(i).equals(this.types.get(i)), (Object)"types must be the same");
        }
        for (i = 0; i < this.types.size(); ++i) {
            Object o2;
            Object o1 = this.values.get(i);
            int result = Tuple.compare(o1, o2 = o.getValues().get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.types, tuple.types) && Objects.equals(this.values, tuple.values);
    }

    public int hashCode() {
        return Objects.hash(this.types, this.values);
    }

    private static <T> int compare(Object o1, Object o2) {
        return ((Comparable)o1).compareTo(o2);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).toString();
    }
}

