/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.systemtables;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.raptor.legacy.RaptorTableHandle;
import io.prestosql.plugin.raptor.legacy.metadata.DatabaseShardManager;
import io.prestosql.plugin.raptor.legacy.metadata.MetadataDao;
import io.prestosql.plugin.raptor.legacy.metadata.TableColumn;
import io.prestosql.plugin.raptor.legacy.systemtables.PageListBuilder;
import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.DBIException;

public class ColumnRangesSystemTable
implements SystemTable {
    private static final String MIN_COLUMN_SUFFIX = "_min";
    private static final String MAX_COLUMN_SUFFIX = "_max";
    private static final String COLUMN_RANGES_TABLE_SUFFIX = "$column_ranges";
    private final IDBI dbi;
    private final RaptorTableHandle sourceTable;
    private final List<TableColumn> indexedRaptorColumns;
    private final ConnectorTableMetadata tableMetadata;

    public ColumnRangesSystemTable(RaptorTableHandle sourceTable, IDBI dbi) {
        this.sourceTable = Objects.requireNonNull(sourceTable, "sourceTable is null");
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.indexedRaptorColumns = (List)((MetadataDao)dbi.onDemand(MetadataDao.class)).listTableColumns(sourceTable.getTableId()).stream().filter(column -> ColumnRangesSystemTable.isIndexedType(column.getDataType())).collect(ImmutableList.toImmutableList());
        List systemTableColumns = (List)this.indexedRaptorColumns.stream().flatMap(column -> Stream.of(new ColumnMetadata(column.getColumnName() + MIN_COLUMN_SUFFIX, column.getDataType(), null, false), new ColumnMetadata(column.getColumnName() + MAX_COLUMN_SUFFIX, column.getDataType(), null, false))).collect(ImmutableList.toImmutableList());
        SchemaTableName tableName = new SchemaTableName(sourceTable.getSchemaName(), sourceTable.getTableName() + COLUMN_RANGES_TABLE_SUFFIX);
        this.tableMetadata = new ConnectorTableMetadata(tableName, systemTableColumns);
    }

    public static Optional<SchemaTableName> getSourceTable(SchemaTableName tableName) {
        if (tableName.getTableName().endsWith(COLUMN_RANGES_TABLE_SUFFIX) && !tableName.getTableName().equals(COLUMN_RANGES_TABLE_SUFFIX)) {
            int tableNameLength = tableName.getTableName().length() - COLUMN_RANGES_TABLE_SUFFIX.length();
            return Optional.of(new SchemaTableName(tableName.getSchemaName(), tableName.getTableName().substring(0, tableNameLength)));
        }
        return Optional.empty();
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        String metadataSqlQuery = ColumnRangesSystemTable.getColumnRangesMetadataSqlQuery(this.sourceTable, this.indexedRaptorColumns);
        List columnTypes = (List)this.tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        PageListBuilder pageListBuilder = new PageListBuilder(columnTypes);
        try (Connection connection = this.dbi.open().getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(metadataSqlQuery);){
            if (resultSet.next()) {
                pageListBuilder.beginRow();
                for (int i = 0; i < columnTypes.size(); ++i) {
                    BlockBuilder blockBuilder = pageListBuilder.nextBlockBuilder();
                    Type columnType = (Type)columnTypes.get(i);
                    if (columnType.equals(BigintType.BIGINT) || columnType.equals(DateType.DATE) || columnType.equals(TimestampType.TIMESTAMP)) {
                        long value = resultSet.getLong(i + 1);
                        if (!resultSet.wasNull()) {
                            columnType.writeLong(blockBuilder, value);
                            continue;
                        }
                        blockBuilder.appendNull();
                        continue;
                    }
                    if (columnType.equals(BooleanType.BOOLEAN)) {
                        boolean value = resultSet.getBoolean(i + 1);
                        if (!resultSet.wasNull()) {
                            BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
                            continue;
                        }
                        blockBuilder.appendNull();
                        continue;
                    }
                    throw new VerifyException("Unknown or unsupported column type: " + columnType);
                }
            }
        }
        catch (SQLException | DBIException e) {
            throw DatabaseUtil.metadataError(e);
        }
        return new FixedPageSource(pageListBuilder.build());
    }

    private static boolean isIndexedType(Type type) {
        return type.equals(BooleanType.BOOLEAN) || type.equals(BigintType.BIGINT) || type.equals(DateType.DATE) || type.equals(TimestampType.TIMESTAMP);
    }

    private static String getColumnRangesMetadataSqlQuery(RaptorTableHandle raptorTableHandle, List<TableColumn> raptorColumns) {
        String columns = raptorColumns.stream().flatMap(column -> Stream.of(String.format("min(%s)", DatabaseShardManager.minColumn(column.getColumnId())), String.format("max(%s)", DatabaseShardManager.maxColumn(column.getColumnId())))).collect(Collectors.joining(", "));
        return String.format("SELECT %s FROM %s", columns, DatabaseShardManager.shardIndexTable(raptorTableHandle.getTableId()));
    }
}

