/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.systemtables;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.raptor.legacy.util.UuidUtil;
import io.prestosql.spi.type.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class ResultSetValues {
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final String[] strings;
    private final boolean[] nulls;
    private final List<Type> types;

    public ResultSetValues(List<Type> types) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.booleans = new boolean[types.size()];
        this.longs = new long[types.size()];
        this.doubles = new double[types.size()];
        this.strings = new String[types.size()];
        this.nulls = new boolean[types.size()];
    }

    int extractValues(ResultSet resultSet, Set<Integer> uuidColumns, Set<Integer> hexColumns) throws SQLException {
        Preconditions.checkArgument((resultSet != null ? 1 : 0) != 0, (Object)"resultSet is null");
        int completedBytes = 0;
        for (int i = 0; i < this.types.size(); ++i) {
            Class javaType = this.types.get(i).getJavaType();
            if (javaType == Boolean.TYPE) {
                this.booleans[i] = resultSet.getBoolean(i + 1);
                this.nulls[i] = resultSet.wasNull();
                if (this.nulls[i]) continue;
                ++completedBytes;
                continue;
            }
            if (javaType == Long.TYPE) {
                this.longs[i] = resultSet.getLong(i + 1);
                this.nulls[i] = resultSet.wasNull();
                if (this.nulls[i]) continue;
                completedBytes += 8;
                continue;
            }
            if (javaType == Double.TYPE) {
                this.doubles[i] = resultSet.getDouble(i + 1);
                this.nulls[i] = resultSet.wasNull();
                if (this.nulls[i]) continue;
                completedBytes += 8;
                continue;
            }
            if (javaType == Slice.class) {
                if (uuidColumns.contains(i)) {
                    byte[] bytes = resultSet.getBytes(i + 1);
                    this.nulls[i] = resultSet.wasNull();
                    this.strings[i] = this.nulls[i] ? null : UuidUtil.uuidFromBytes(bytes).toString().toLowerCase(Locale.ENGLISH);
                } else if (hexColumns.contains(i)) {
                    long value = resultSet.getLong(i + 1);
                    this.nulls[i] = resultSet.wasNull();
                    this.strings[i] = this.nulls[i] ? null : String.format("%016x", value);
                } else {
                    String value = resultSet.getString(i + 1);
                    this.nulls[i] = resultSet.wasNull();
                    String string = this.strings[i] = this.nulls[i] ? null : value;
                }
                if (this.nulls[i]) continue;
                completedBytes += this.strings[i].length();
                continue;
            }
            throw new VerifyException("Unknown Java type: " + javaType);
        }
        return completedBytes;
    }

    public boolean getBoolean(int field) {
        return this.booleans[field];
    }

    public long getLong(int field) {
        return this.longs[field];
    }

    public double getDouble(int field) {
        return this.doubles[field];
    }

    public Slice getSlice(int field) {
        return Slices.wrappedBuffer((byte[])this.strings[field].getBytes());
    }

    public boolean isNull(int field) {
        return this.nulls[field];
    }
}

