/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.raptor.legacy.systemtables;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.plugin.raptor.legacy.metadata.ForMetadata;
import io.prestosql.plugin.raptor.legacy.metadata.MetadataDao;
import io.prestosql.plugin.raptor.legacy.metadata.TableStatsRow;
import io.prestosql.plugin.raptor.legacy.systemtables.PageListBuilder;
import io.prestosql.plugin.raptor.legacy.systemtables.TableMetadataSystemTable;
import io.prestosql.plugin.raptor.legacy.util.DatabaseUtil;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.skife.jdbi.v2.IDBI;

public class TableStatsSystemTable
implements SystemTable {
    private static final String SCHEMA_NAME = "table_schema";
    private static final String TABLE_NAME = "table_name";
    private static final ConnectorTableMetadata METADATA = new ConnectorTableMetadata(new SchemaTableName("system", "table_stats"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("table_schema", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("table_name", (Type)VarcharType.createUnboundedVarcharType())).add((Object)new ColumnMetadata("create_time", (Type)TimestampType.TIMESTAMP)).add((Object)new ColumnMetadata("update_time", (Type)TimestampType.TIMESTAMP)).add((Object)new ColumnMetadata("table_version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("shard_count", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("row_count", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("compressed_size", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("uncompressed_size", (Type)BigintType.BIGINT)).build());
    private final MetadataDao dao;

    @Inject
    public TableStatsSystemTable(@ForMetadata IDBI dbi) {
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(TableStatsSystemTable.buildPages(this.dao, constraint));
    }

    private static List<Page> buildPages(MetadataDao dao, TupleDomain<Integer> tupleDomain) {
        Map domainValues = (Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of());
        String schemaName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(METADATA, SCHEMA_NAME)));
        String tableName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(METADATA, TABLE_NAME)));
        PageListBuilder pageBuilder = new PageListBuilder(METADATA.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList()));
        for (TableStatsRow row : dao.getTableStatsRows(schemaName, tableName)) {
            pageBuilder.beginRow();
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)row.getSchemaName()));
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)row.getTableName()));
            TimestampType.TIMESTAMP.writeLong(pageBuilder.nextBlockBuilder(), row.getCreateTime());
            TimestampType.TIMESTAMP.writeLong(pageBuilder.nextBlockBuilder(), row.getUpdateTime());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getTableVersion());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getShardCount());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getRowCount());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getCompressedSize());
            BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), row.getUncompressedSize());
        }
        return pageBuilder.build();
    }
}

