/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.orc.DiskRange;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.orc.OrcDataSourceUtils;
import io.prestosql.orc.stream.AbstractDiskOrcDataReader;
import io.prestosql.orc.stream.MemoryOrcDataReader;
import io.prestosql.orc.stream.OrcDataReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOrcDataSource
implements OrcDataSource {
    private final OrcDataSourceId id;
    private final long size;
    private final DataSize maxMergeDistance;
    private final DataSize maxBufferSize;
    private final DataSize streamBufferSize;
    private final boolean lazyReadSmallRanges;
    private long readTimeNanos;
    private long readBytes;

    public AbstractOrcDataSource(OrcDataSourceId id, long size, DataSize maxMergeDistance, DataSize maxBufferSize, DataSize streamBufferSize, boolean lazyReadSmallRanges) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.size = size;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"size must be at least 1");
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
        this.lazyReadSmallRanges = lazyReadSmallRanges;
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5) throws IOException;

    @Override
    public OrcDataSourceId getId() {
        return this.id;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final Slice readFully(long position, int length) throws IOException {
        byte[] buffer = new byte[length];
        this.readFully(position, buffer, 0, length);
        return Slices.wrappedBuffer((byte[])buffer);
    }

    private void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public final <K> Map<K, OrcDataReader> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        long maxReadSizeBytes = this.maxBufferSize.toBytes();
        ImmutableMap.Builder smallRangesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder largeRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            if ((long)entry.getValue().getLength() <= maxReadSizeBytes) {
                smallRangesBuilder.put(entry);
                continue;
            }
            largeRangesBuilder.put(entry);
        }
        ImmutableMap smallRanges = smallRangesBuilder.build();
        ImmutableMap largeRanges = largeRangesBuilder.build();
        ImmutableMap.Builder slices = ImmutableMap.builder();
        slices.putAll(this.readSmallDiskRanges((Map<K, DiskRange>)smallRanges));
        slices.putAll(this.readLargeDiskRanges((Map<K, DiskRange>)largeRanges));
        return slices.build();
    }

    private <K> Map<K, OrcDataReader> readSmallDiskRanges(Map<K, DiskRange> diskRanges) throws IOException {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        List<DiskRange> mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), this.maxMergeDistance, this.maxBufferSize);
        ImmutableMap.Builder slices = ImmutableMap.builder();
        if (this.lazyReadSmallRanges) {
            for (DiskRange mergedRange : mergedRanges) {
                LazyBufferLoader lazyBufferLoader = new LazyBufferLoader(mergedRange);
                for (Map.Entry<K, DiskRange> diskRangeEntry : diskRanges.entrySet()) {
                    DiskRange diskRange = diskRangeEntry.getValue();
                    if (!mergedRange.contains(diskRange)) continue;
                    slices.put(diskRangeEntry.getKey(), (Object)new MergedOrcDataReader(this.id, diskRange, lazyBufferLoader));
                }
            }
        } else {
            LinkedHashMap<DiskRange, Slice> buffers = new LinkedHashMap<DiskRange, Slice>();
            for (DiskRange diskRange : mergedRanges) {
                Slice buffer = this.readFully(diskRange.getOffset(), diskRange.getLength());
                buffers.put(diskRange, buffer);
            }
            for (Map.Entry entry : diskRanges.entrySet()) {
                slices.put(entry.getKey(), (Object)new MemoryOrcDataReader(this.id, OrcDataSourceUtils.getDiskRangeSlice((DiskRange)entry.getValue(), buffers), ((DiskRange)entry.getValue()).getLength()));
            }
        }
        ImmutableMap sliceStreams = slices.build();
        Verify.verify((boolean)sliceStreams.keySet().equals(diskRanges.keySet()));
        return sliceStreams;
    }

    private <K> Map<K, OrcDataReader> readLargeDiskRanges(Map<K, DiskRange> diskRanges) {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            slices.put(entry.getKey(), (Object)new DiskOrcDataReader(diskRange));
        }
        return slices.build();
    }

    public final String toString() {
        return this.id.toString();
    }

    private class DiskOrcDataReader
    extends AbstractDiskOrcDataReader {
        private final DiskRange diskRange;

        public DiskOrcDataReader(DiskRange diskRange) {
            super(AbstractOrcDataSource.this.id, Objects.requireNonNull(diskRange, "diskRange is null").getLength(), Math.toIntExact(AbstractOrcDataSource.this.streamBufferSize.toBytes()));
            this.diskRange = diskRange;
        }

        @Override
        public void read(long position, byte[] buffer, int bufferOffset, int length) throws IOException {
            AbstractOrcDataSource.this.readFully(this.diskRange.getOffset() + position, buffer, bufferOffset, length);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.getOrcDataSourceId()).add("diskRange", (Object)this.diskRange).add("maxBufferSize", this.getMaxBufferSize()).toString();
        }
    }

    private final class MergedOrcDataReader
    implements OrcDataReader {
        private final OrcDataSourceId orcDataSourceId;
        private final DiskRange diskRange;
        private final LazyBufferLoader lazyBufferLoader;
        private Slice data;

        public MergedOrcDataReader(OrcDataSourceId orcDataSourceId, DiskRange diskRange, LazyBufferLoader lazyBufferLoader) {
            this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
            this.lazyBufferLoader = Objects.requireNonNull(lazyBufferLoader, "lazyBufferLoader is null");
        }

        @Override
        public OrcDataSourceId getOrcDataSourceId() {
            return this.orcDataSourceId;
        }

        @Override
        public long getRetainedSize() {
            return this.data == null ? 0L : (long)this.diskRange.getLength();
        }

        @Override
        public int getSize() {
            return this.diskRange.getLength();
        }

        @Override
        public int getMaxBufferSize() {
            return this.diskRange.getLength();
        }

        @Override
        public Slice seekBuffer(int newPosition) throws IOException {
            if (this.data == null) {
                this.data = this.lazyBufferLoader.loadNestedDiskRangeBuffer(this.diskRange);
                if (this.data == null) {
                    throw new OrcCorruptionException(AbstractOrcDataSource.this.id, "Data loader returned null");
                }
                if (this.data.length() != this.diskRange.getLength()) {
                    throw new OrcCorruptionException(AbstractOrcDataSource.this.id, "Expected to load %s bytes, but %s bytes were loaded", this.diskRange.getLength(), this.data.length());
                }
            }
            return this.data.slice(newPosition, this.data.length() - newPosition);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.orcDataSourceId).add("diskRange", (Object)this.diskRange).toString();
        }
    }

    private final class LazyBufferLoader {
        private final DiskRange diskRange;
        private Slice bufferSlice;

        public LazyBufferLoader(DiskRange diskRange) {
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
        }

        public Slice loadNestedDiskRangeBuffer(DiskRange nestedDiskRange) {
            this.load();
            Preconditions.checkArgument((boolean)this.diskRange.contains(nestedDiskRange));
            int offset = Math.toIntExact(nestedDiskRange.getOffset() - this.diskRange.getOffset());
            return this.bufferSlice.slice(offset, nestedDiskRange.getLength());
        }

        private void load() {
            if (this.bufferSlice != null) {
                return;
            }
            try {
                this.bufferSlice = AbstractOrcDataSource.this.readFully(this.diskRange.getOffset(), this.diskRange.getLength());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

