/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.metadata.ColumnEncoding;
import io.prestosql.orc.metadata.Stream;
import io.prestosql.orc.reader.ReaderUtils;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.stream.BooleanInputStream;
import io.prestosql.orc.stream.DecimalInputStream;
import io.prestosql.orc.stream.InputStreamSource;
import io.prestosql.orc.stream.InputStreamSources;
import io.prestosql.orc.stream.LongInputStream;
import io.prestosql.orc.stream.MissingInputStreamSource;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.Int128ArrayBlock;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.UnscaledDecimal128Arithmetic;
import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class DecimalStreamReader
implements StreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DecimalStreamReader.class).instanceSize();
    private final DecimalType type;
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    private boolean[] nullVector = new boolean[0];
    private long[] scaleVector = new long[0];
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<DecimalInputStream> decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    @Nullable
    private DecimalInputStream decimalStream;
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream scaleStream;
    private boolean rowGroupOpen;
    private long[] nonNullValueTemp = new long[0];
    private final LocalMemoryContext systemMemoryContext;

    public DecimalStreamReader(Type type, StreamDescriptor streamDescriptor, LocalMemoryContext systemMemoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(streamDescriptor, type, DecimalType.class::isInstance);
        this.type = (DecimalType)type;
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        if (this.decimalStream == null && this.scaleStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
        } else if (this.presentStream == null) {
            this.checkDataStreamsArePresent();
            block = this.readNonNullBlock();
        } else {
            this.checkDataStreamsArePresent();
            boolean[] isNull = new boolean[this.nextBatchSize];
            int nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull);
            block = nullCount == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)DoubleType.DOUBLE, null, (int)this.nextBatchSize));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void checkDataStreamsArePresent() throws OrcCorruptionException {
        if (this.decimalStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but decimal stream is missing");
        }
        if (this.scaleStream == null) {
            throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but scale stream is missing");
        }
    }

    private Block readNonNullBlock() throws IOException {
        Block block = this.type.isShort() ? this.readShortNotNullBlock() : this.readLongNotNullBlock();
        return block;
    }

    private Block readShortNotNullBlock() throws IOException {
        Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
        Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
        long[] data = new long[this.nextBatchSize];
        this.decimalStream.nextShortDecimal(data, this.nextBatchSize);
        for (int i = 0; i < this.nextBatchSize; ++i) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            data[i] = Decimals.rescale((long)data[i], (int)((int)sourceScale), (int)this.type.getScale());
        }
        return new LongArrayBlock(this.nextBatchSize, Optional.empty(), data);
    }

    private Block readLongNotNullBlock() throws IOException {
        Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
        Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
        long[] data = new long[this.nextBatchSize * 2];
        this.decimalStream.nextLongDecimal(data, this.nextBatchSize);
        for (int offset = 0; offset < data.length; offset += 2) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            Slice decimal = Slices.wrappedLongArray((long[])new long[]{data[offset], data[offset + 1]});
            UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)this.type.getScale() - sourceScale)), (Slice)Slices.wrappedLongArray((long[])data, (int)offset, (int)2));
        }
        return new Int128ArrayBlock(this.nextBatchSize, Optional.empty(), data);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Block block = this.type.isShort() ? this.readShortNullBlock(isNull, nonNullCount) : this.readLongNullBlock(isNull, nonNullCount);
        return block;
    }

    private Block readShortNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
        Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.nonNullValueTemp.length < minNonNullValueSize) {
            this.nonNullValueTemp = new long[minNonNullValueSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((long[])this.nonNullValueTemp));
        }
        this.decimalStream.nextShortDecimal(this.nonNullValueTemp, nonNullCount);
        for (int i = 0; i < nonNullCount; ++i) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            this.nonNullValueTemp[i] = Decimals.rescale((long)this.nonNullValueTemp[i], (int)((int)sourceScale), (int)this.type.getScale());
        }
        long[] result = ReaderUtils.unpackLongNulls(this.nonNullValueTemp, isNull);
        return new LongArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block readLongNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
        Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
        int minTempSize = ReaderUtils.minNonNullValueSize(nonNullCount) * 2;
        if (this.nonNullValueTemp.length < minTempSize) {
            this.nonNullValueTemp = new long[minTempSize];
            this.systemMemoryContext.setBytes(SizeOf.sizeOf((long[])this.nonNullValueTemp));
        }
        this.decimalStream.nextLongDecimal(this.nonNullValueTemp, nonNullCount);
        for (int offset = 0; offset < nonNullCount * 2; offset += 2) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            Slice decimal = Slices.wrappedLongArray((long[])new long[]{this.nonNullValueTemp[offset], this.nonNullValueTemp[offset + 1]});
            UnscaledDecimal128Arithmetic.rescale((Slice)decimal, (int)((int)((long)this.type.getScale() - sourceScale)), (Slice)Slices.wrappedLongArray((long[])this.nonNullValueTemp, (int)offset, (int)2));
        }
        long[] result = ReaderUtils.unpackInt128Nulls(this.nonNullValueTemp, isNull);
        return new Int128ArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                this.checkDataStreamsArePresent();
                Verify.verify((this.decimalStream != null ? 1 : 0) != 0);
                Verify.verify((this.scaleStream != null ? 1 : 0) != 0);
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    @Override
    public void startStripe(ZoneId timeZone, InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.decimalStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public void close() {
        this.systemMemoryContext.close();
        this.nullVector = null;
        this.scaleVector = null;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.nullVector) + SizeOf.sizeOf((long[])this.scaleVector);
    }
}

