/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc.reader;

import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.orc.OrcCorruptionException;
import io.prestosql.orc.StreamDescriptor;
import io.prestosql.orc.reader.BooleanStreamReader;
import io.prestosql.orc.reader.ByteStreamReader;
import io.prestosql.orc.reader.DecimalStreamReader;
import io.prestosql.orc.reader.DoubleStreamReader;
import io.prestosql.orc.reader.FloatStreamReader;
import io.prestosql.orc.reader.ListStreamReader;
import io.prestosql.orc.reader.LongStreamReader;
import io.prestosql.orc.reader.MapStreamReader;
import io.prestosql.orc.reader.SliceStreamReader;
import io.prestosql.orc.reader.StreamReader;
import io.prestosql.orc.reader.StructStreamReader;
import io.prestosql.orc.reader.TimestampStreamReader;
import io.prestosql.spi.type.Type;

public final class StreamReaders {
    private StreamReaders() {
    }

    public static StreamReader createStreamReader(Type type, StreamDescriptor streamDescriptor, AggregatedMemoryContext systemMemoryContext) throws OrcCorruptionException {
        switch (streamDescriptor.getStreamType()) {
            case BOOLEAN: {
                return new BooleanStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                return new ByteStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                return new LongStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case FLOAT: {
                return new FloatStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                return new DoubleStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return new SliceStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case TIMESTAMP: {
                return new TimestampStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
            case LIST: {
                return new ListStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case STRUCT: {
                return new StructStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case MAP: {
                return new MapStreamReader(type, streamDescriptor, systemMemoryContext);
            }
            case DECIMAL: {
                return new DecimalStreamReader(type, streamDescriptor, systemMemoryContext.newLocalMemoryContext(StreamReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getStreamType()));
    }
}

