/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.base.security;

import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.ConnectorIdentity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingConnectorAccessControl
implements ConnectorAccessControl {
    public static ConnectorAccessControl of(final Supplier<ConnectorAccessControl> connectorAccessControlSupplier) {
        Objects.requireNonNull(connectorAccessControlSupplier, "connectorAccessControlSupplier is null");
        return new ForwardingConnectorAccessControl(){

            @Override
            protected ConnectorAccessControl delegate() {
                return (ConnectorAccessControl)connectorAccessControlSupplier.get();
            }
        };
    }

    protected abstract ConnectorAccessControl delegate();

    public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate().checkCanCreateSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate().checkCanDropSchema(transactionHandle, identity, schemaName);
    }

    public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(transactionHandle, identity, schemaName, newSchemaName);
    }

    public void checkCanShowSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity) {
        this.delegate().checkCanShowSchemas(transactionHandle, identity);
    }

    public Set<String> filterSchemas(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> schemaNames) {
        return this.delegate().filterSchemas(transactionHandle, identity, schemaNames);
    }

    public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanCreateTable(transactionHandle, identity, tableName);
    }

    public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanDropTable(transactionHandle, identity, tableName);
    }

    public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, SchemaTableName newTableName) {
        this.delegate().checkCanRenameTable(transactionHandle, identity, tableName, newTableName);
    }

    public void checkCanSetTableComment(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanSetTableComment(transactionHandle, identity, tableName);
    }

    public void checkCanShowTablesMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String schemaName) {
        this.delegate().checkCanShowTablesMetadata(transactionHandle, identity, schemaName);
    }

    public Set<SchemaTableName> filterTables(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(transactionHandle, identity, tableNames);
    }

    public void checkCanShowColumnsMetadata(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanShowColumnsMetadata(transactionHandle, identity, tableName);
    }

    public List<ColumnMetadata> filterColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, List<ColumnMetadata> columns) {
        return this.delegate().filterColumns(transactionHandle, identity, tableName, columns);
    }

    public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanAddColumn(transactionHandle, identity, tableName);
    }

    public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanDropColumn(transactionHandle, identity, tableName);
    }

    public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanRenameColumn(transactionHandle, identity, tableName);
    }

    public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanInsertIntoTable(transactionHandle, identity, tableName);
    }

    public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName) {
        this.delegate().checkCanDeleteFromTable(transactionHandle, identity, tableName);
    }

    public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        this.delegate().checkCanCreateView(transactionHandle, identity, viewName);
    }

    public void checkCanDropView(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName viewName) {
        this.delegate().checkCanDropView(transactionHandle, identity, viewName);
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(transactionHandle, identity, tableName, columnNames);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(transactionHandle, identity, propertyName);
    }

    public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, privilege, tableName, grantee, withGrantOption);
    }

    public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Privilege privilege, SchemaTableName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        this.delegate().checkCanGrantTablePrivilege(transactionHandle, identity, privilege, tableName, revokee, grantOptionFor);
    }

    public void checkCanCreateRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, Optional<PrestoPrincipal> grantor) {
        this.delegate().checkCanCreateRole(transactionHandle, identity, role, grantor);
    }

    public void checkCanDropRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role) {
        this.delegate().checkCanDropRole(transactionHandle, identity, role);
    }

    public void checkCanGrantRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanGrantRoles(transactionHandle, identity, roles, grantees, withAdminOption, grantor, catalogName);
    }

    public void checkCanRevokeRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        this.delegate().checkCanRevokeRoles(transactionHandle, identity, roles, grantees, adminOptionFor, grantor, catalogName);
    }

    public void checkCanSetRole(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String role, String catalogName) {
        this.delegate().checkCanSetRole(transactionHandle, identity, role, catalogName);
    }

    public void checkCanShowRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate().checkCanShowRoles(transactionHandle, identity, catalogName);
    }

    public void checkCanShowCurrentRoles(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate().checkCanShowCurrentRoles(transactionHandle, identity, catalogName);
    }

    public void checkCanShowRoleGrants(ConnectorTransactionHandle transactionHandle, ConnectorIdentity identity, String catalogName) {
        this.delegate().checkCanShowRoleGrants(transactionHandle, identity, catalogName);
    }
}

