/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ErrorReceivingResponseEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.LocationMode;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestCompletedEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestResult;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ResponseReceivedEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryInfo;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryNoRetry;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryPolicy;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryPolicyFactory;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RetryingEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.SendingRequestEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageLocation;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.BaseResponse;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Logger;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StorageRequest;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StreamMd5AndLength;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public final class ExecutionEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> RESULT_TYPE executeWithRetry(CLIENT_TYPE client, PARENT_TYPE parentObject, StorageRequest<CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> task, RetryPolicyFactory policyFactory, OperationContext opContext) throws StorageException {
        RetryPolicy policy = null;
        if (policyFactory == null) {
            policy = new RetryNoRetry();
        } else {
            policy = policyFactory.createInstance(opContext);
            if (policy == null) {
                policy = new RetryNoRetry();
            }
        }
        int currentRetryCount = 0;
        StorageException translatedException = null;
        HttpURLConnection request = null;
        long startTime = new Date().getTime();
        while (true) {
            try {
                request = ExecutionEngine.setupStorageRequest(client, parentObject, task, currentRetryCount, opContext);
                Logger.info(opContext, "Starting request to '%s' at '%s'.", (Object)request.getURL(), (Object)request.getRequestProperty("x-ms-date"));
                boolean responseReceivedEventTriggered = false;
                try {
                    if (task.getSendStream() != null) {
                        Logger.info(opContext, "Writing request data.");
                        if (task.getLength() >= 0L) {
                            request.setFixedLengthStreamingMode(task.getLength());
                        }
                        StreamMd5AndLength descriptor = Utility.writeToOutputStream(task.getSendStream(), request.getOutputStream(), task.getLength(), false, false, opContext, task.getRequestOptions());
                        task.validateStreamWrite(descriptor);
                        Logger.info(opContext, "Request data was written successfully.");
                    }
                    Utility.logHttpRequest(request, opContext);
                    RequestResult currResult = task.getResult();
                    currResult.setStartDate(new Date());
                    Logger.info(opContext, "Waiting for response.");
                    currResult.setStatusCode(request.getResponseCode());
                    currResult.setStatusMessage(request.getResponseMessage());
                    currResult.setStopDate(new Date());
                    currResult.setServiceRequestID(BaseResponse.getRequestId(request));
                    currResult.setEtag(BaseResponse.getEtag(request));
                    currResult.setRequestDate(BaseResponse.getDate(request));
                    currResult.setContentMD5(BaseResponse.getContentMD5(request));
                    currResult.setErrorCode(BaseResponse.getErrorCode(request));
                    responseReceivedEventTriggered = true;
                    ExecutionEngine.fireResponseReceivedEvent(opContext, request, task.getResult());
                    Logger.info(opContext, "Response received. Status code = '%d', Request ID = '%s', Content-MD5 = '%s', ETag = '%s', Date = '%s'.", currResult.getStatusCode(), currResult.getServiceRequestID(), currResult.getContentMD5(), currResult.getEtag(), currResult.getRequestDate());
                    Utility.logHttpResponse(request, opContext);
                }
                finally {
                    Logger.info(opContext, "A network error occurred before the HTTP response status and headers were received.");
                    if (!responseReceivedEventTriggered) {
                        if (task.getResult().getStartDate() == null) {
                            task.getResult().setStartDate(new Date());
                        }
                        ExecutionEngine.fireErrorReceivingResponseEvent(opContext, request, task.getResult());
                    }
                }
                Logger.info(opContext, "Processing response headers.");
                RESULT_TYPE result = task.preProcessResponse(parentObject, client, opContext);
                Logger.info(opContext, "Response headers were processed successfully.");
                if (!task.isNonExceptionedRetryableFailure()) {
                    Object inStream;
                    Logger.info(opContext, "Processing response body.");
                    result = task.postProcessResponse(request, parentObject, client, opContext, result);
                    Logger.info(opContext, "Response body was parsed successfully.");
                    if (task.getResult().getStatusCode() >= 200 && task.getResult().getStatusCode() < 300 && request != null) {
                        inStream = request.getInputStream();
                        try {
                            Utility.writeToOutputStream((InputStream)inStream, null, -1L, false, false, null, task.getRequestOptions());
                        }
                        catch (IOException ex) {
                        }
                        catch (StorageException e) {
                        }
                        finally {
                            ((InputStream)inStream).close();
                        }
                    }
                    Logger.info(opContext, "Operation completed.");
                    inStream = result;
                    return (RESULT_TYPE)inStream;
                }
                Logger.warn(opContext, "Operation did not return the expected result or returned an exception.");
                translatedException = task.materializeException(opContext);
                task.getResult().setException(translatedException);
                if (task.getResult().getStatusCode() == 501 || task.getResult().getStatusCode() == 505 || translatedException.getErrorCode().equals("InvalidBlobType")) {
                    throw translatedException;
                }
            }
            catch (StorageException e) {
                task.getResult().setStatusCode(e.getHttpStatusCode());
                task.getResult().setStatusMessage(e.getMessage());
                task.getResult().setException(e);
                Logger.warn(opContext, "Retryable exception thrown. Class = '%s', Message = '%s'.", (Object)e.getClass().getName(), (Object)e.getMessage());
                translatedException = e;
            }
            catch (Exception e) {
                Logger.warn(opContext, "Retryable exception thrown. Class = '%s', Message = '%s'.", (Object)e.getClass().getName(), (Object)e.getMessage());
                translatedException = StorageException.translateException(task, e, opContext);
                task.getResult().setException(translatedException);
            }
            finally {
                opContext.setClientTimeInMs(new Date().getTime() - startTime);
                if (task.isSent()) {
                    ExecutionEngine.fireRequestCompletedEvent(opContext, request, task.getResult());
                }
            }
            Logger.info(opContext, "Checking if the operation should be retried. Retry count = '%d', HTTP status code = '%d', Error Message = '%s'.", currentRetryCount, task.getResult().getStatusCode(), translatedException == null ? null : translatedException.getMessage());
            task.setCurrentLocation(ExecutionEngine.getNextLocation(task.getCurrentLocation(), task.getLocationMode()));
            Logger.info(opContext, "The next location has been set to '%s', per location mode '%s'.", (Object)task.getCurrentLocation(), (Object)task.getLocationMode());
            RetryContext retryContext = new RetryContext(currentRetryCount++, task.getResult(), task.getCurrentLocation(), task.getLocationMode());
            RetryInfo retryInfo = policy.evaluate(retryContext, opContext);
            if (retryInfo == null) {
                Logger.error(opContext, "Retry policy did not allow for a retry. Failing. Error Message = '%s'.", (Object)(translatedException == null ? null : translatedException.getMessage()));
                throw translatedException;
            }
            if (Utility.validateMaxExecutionTimeout(task.getRequestOptions().getOperationExpiryTimeInMs(), retryInfo.getRetryInterval())) {
                TimeoutException timeoutException = new TimeoutException("The client could not finish the operation within specified maximum execution timeout.");
                translatedException = new StorageException("OperationTimedOut", "The client could not finish the operation within specified maximum execution timeout.", 306, null, timeoutException);
                task.initialize(opContext);
                task.getResult().setException(translatedException);
                Logger.error(opContext, "Operation cannot be retried because maximum execution timeout has been reached. Failing. Inner error Message = '%s'.", (Object)(translatedException == null ? null : translatedException.getMessage()));
                throw translatedException;
            }
            task.setCurrentLocation(retryInfo.getTargetLocation());
            task.setLocationMode(retryInfo.getUpdatedLocationMode());
            Logger.info(opContext, "The retry policy set the next location to '%s' and updated the location mode to '%s'.", (Object)task.getCurrentLocation(), (Object)task.getLocationMode());
            try {
                ExecutionEngine.fireRetryingEvent(opContext, task.getConnection(), task.getResult(), retryContext);
                Logger.info(opContext, "Operation will be retried after '%d'ms.", (Object)retryInfo.getRetryInterval());
                Thread.sleep(retryInfo.getRetryInterval());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private static <CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> HttpURLConnection setupStorageRequest(CLIENT_TYPE client, PARENT_TYPE parentObject, StorageRequest<CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> task, int currentRetryCount, OperationContext opContext) throws StorageException {
        try {
            task.initialize(opContext);
            if (Utility.validateMaxExecutionTimeout(task.getRequestOptions().getOperationExpiryTimeInMs())) {
                TimeoutException timeoutException = new TimeoutException("The client could not finish the operation within specified maximum execution timeout.");
                throw new StorageException("OperationTimedOut", "The client could not finish the operation within specified maximum execution timeout.", 306, null, timeoutException);
            }
            if (currentRetryCount > 0) {
                task.recoveryAction(opContext);
                Logger.info(opContext, "Retrying failed operation.");
            } else {
                task.applyLocationModeToRequest();
                task.initializeLocation();
                Logger.info(opContext, "Starting operation.");
            }
            task.setRequestLocationMode();
            task.validateLocation();
            Logger.info(opContext, "Starting operation with location '%s' per location mode '%s'.", (Object)task.getCurrentLocation(), (Object)task.getLocationMode());
            HttpURLConnection request = task.buildRequest(client, parentObject, opContext);
            task.setHeaders(request, parentObject, opContext);
            if (opContext.getUserHeaders() != null) {
                for (Map.Entry<String, String> entry : opContext.getUserHeaders().entrySet()) {
                    request.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            ExecutionEngine.fireSendingRequestEvent(opContext, request, task.getResult());
            task.setIsSent(true);
            task.signRequest(request, client, opContext);
            task.setConnection(request);
            return request;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(null, e.getMessage(), 306, null, e);
        }
    }

    private static StorageLocation getNextLocation(StorageLocation lastLocation, LocationMode locationMode) {
        switch (locationMode) {
            case PRIMARY_ONLY: {
                return StorageLocation.PRIMARY;
            }
            case SECONDARY_ONLY: {
                return StorageLocation.SECONDARY;
            }
            case PRIMARY_THEN_SECONDARY: 
            case SECONDARY_THEN_PRIMARY: {
                return lastLocation == StorageLocation.PRIMARY ? StorageLocation.SECONDARY : StorageLocation.PRIMARY;
            }
        }
        return StorageLocation.PRIMARY;
    }

    private static void fireSendingRequestEvent(OperationContext opContext, HttpURLConnection request, RequestResult result) {
        if (opContext.getSendingRequestEventHandler().hasListeners() || OperationContext.getGlobalSendingRequestEventHandler().hasListeners()) {
            SendingRequestEvent event = new SendingRequestEvent(opContext, request, result);
            opContext.getSendingRequestEventHandler().fireEvent(event);
            OperationContext.getGlobalSendingRequestEventHandler().fireEvent(event);
        }
    }

    private static void fireResponseReceivedEvent(OperationContext opContext, HttpURLConnection request, RequestResult result) {
        if (opContext.getResponseReceivedEventHandler().hasListeners() || OperationContext.getGlobalResponseReceivedEventHandler().hasListeners()) {
            ResponseReceivedEvent event = new ResponseReceivedEvent(opContext, request, result);
            opContext.getResponseReceivedEventHandler().fireEvent(event);
            OperationContext.getGlobalResponseReceivedEventHandler().fireEvent(event);
        }
    }

    private static void fireErrorReceivingResponseEvent(OperationContext opContext, HttpURLConnection request, RequestResult result) {
        if (opContext.getErrorReceivingResponseEventHandler().hasListeners() || OperationContext.getGlobalErrorReceivingResponseEventHandler().hasListeners()) {
            ErrorReceivingResponseEvent event = new ErrorReceivingResponseEvent(opContext, request, result);
            opContext.getErrorReceivingResponseEventHandler().fireEvent(event);
            OperationContext.getGlobalErrorReceivingResponseEventHandler().fireEvent(event);
        }
    }

    private static void fireRequestCompletedEvent(OperationContext opContext, HttpURLConnection request, RequestResult result) {
        if (opContext.getRequestCompletedEventHandler().hasListeners() || OperationContext.getGlobalRequestCompletedEventHandler().hasListeners()) {
            RequestCompletedEvent event = new RequestCompletedEvent(opContext, request, result);
            opContext.getRequestCompletedEventHandler().fireEvent(event);
            OperationContext.getGlobalRequestCompletedEventHandler().fireEvent(event);
        }
    }

    private static void fireRetryingEvent(OperationContext opContext, HttpURLConnection request, RequestResult result, RetryContext retryContext) {
        if (opContext.getRetryingEventHandler().hasListeners() || OperationContext.getGlobalRetryingEventHandler().hasListeners()) {
            RetryingEvent event = new RetryingEvent(opContext, request, result, retryContext);
            opContext.getRetryingEventHandler().fireEvent(event);
            OperationContext.getGlobalRetryingEventHandler().fireEvent(event);
        }
    }
}

