/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.io.netty.handler.codec.spdy;

import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpHeaders;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpMessage;

public final class SpdyHttpHeaders {
    private SpdyHttpHeaders() {
    }

    public static void removeStreamId(HttpMessage message) {
        message.headers().remove("x-spdy-stream-id");
    }

    public static int getStreamId(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "x-spdy-stream-id");
    }

    public static void setStreamId(HttpMessage message, int streamId) {
        HttpHeaders.setIntHeader(message, "x-spdy-stream-id", streamId);
    }

    public static void removeAssociatedToStreamId(HttpMessage message) {
        message.headers().remove("x-spdy-associated-to-stream-id");
    }

    public static int getAssociatedToStreamId(HttpMessage message) {
        return HttpHeaders.getIntHeader(message, "x-spdy-associated-to-stream-id", 0);
    }

    public static void setAssociatedToStreamId(HttpMessage message, int associatedToStreamId) {
        HttpHeaders.setIntHeader(message, "x-spdy-associated-to-stream-id", associatedToStreamId);
    }

    public static void removePriority(HttpMessage message) {
        message.headers().remove("x-spdy-priority");
    }

    public static byte getPriority(HttpMessage message) {
        return (byte)HttpHeaders.getIntHeader(message, "x-spdy-priority", 0);
    }

    public static void setPriority(HttpMessage message, byte priority) {
        HttpHeaders.setIntHeader(message, "x-spdy-priority", (int)priority);
    }

    public static void removeScheme(HttpMessage message) {
        message.headers().remove("x-spdy-scheme");
    }

    public static String getScheme(HttpMessage message) {
        return message.headers().get("x-spdy-scheme");
    }

    public static void setScheme(HttpMessage message, String scheme) {
        message.headers().set("x-spdy-scheme", (Object)scheme);
    }

    public static final class Names {
        public static final String STREAM_ID = "x-spdy-stream-id";
        public static final String ASSOCIATED_TO_STREAM_ID = "x-spdy-associated-to-stream-id";
        public static final String PRIORITY = "x-spdy-priority";
        public static final String SCHEME = "x-spdy-scheme";

        private Names() {
        }
    }
}

