/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.commons.configuration2;

import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.Configuration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.FileBasedConfiguration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.MapConfiguration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.PropertiesConfiguration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.XMLPropertiesConfiguration;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.ex.ConfigurationException;
import io.prestosql.hadoop.$internal.org.apache.commons.configuration2.io.FileHandler;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.util.Iterator;

public class SystemConfiguration
extends MapConfiguration {
    private static Log log = LogFactory.getLog(SystemConfiguration.class);

    public SystemConfiguration() {
        super(System.getProperties());
    }

    public static void setSystemProperties(String fileName) throws ConfigurationException {
        SystemConfiguration.setSystemProperties(null, fileName);
    }

    public static void setSystemProperties(String basePath, String fileName) throws ConfigurationException {
        FileBasedConfiguration config = (FileBasedConfiguration)((Object)(fileName.endsWith(".xml") ? new XMLPropertiesConfiguration() : new PropertiesConfiguration()));
        FileHandler handler = new FileHandler(config);
        handler.setBasePath(basePath);
        handler.setFileName(fileName);
        handler.load();
        SystemConfiguration.setSystemProperties(config);
    }

    public static void setSystemProperties(Configuration systemConfig) {
        Iterator<String> iter = systemConfig.getKeys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = (String)systemConfig.getProperty(key);
            if (log.isDebugEnabled()) {
                log.debug("Setting system property " + key + " to " + value);
            }
            System.setProperty(key, value);
        }
    }

    @Override
    protected Iterator<String> getKeysInternal() {
        return System.getProperties().stringPropertyNames().iterator();
    }
}

