/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.http.protocol;

import io.prestosql.hadoop.$internal.org.apache.http.HttpConnection;
import io.prestosql.hadoop.$internal.org.apache.http.HttpException;
import io.prestosql.hadoop.$internal.org.apache.http.HttpHost;
import io.prestosql.hadoop.$internal.org.apache.http.HttpInetConnection;
import io.prestosql.hadoop.$internal.org.apache.http.HttpRequest;
import io.prestosql.hadoop.$internal.org.apache.http.HttpRequestInterceptor;
import io.prestosql.hadoop.$internal.org.apache.http.HttpVersion;
import io.prestosql.hadoop.$internal.org.apache.http.ProtocolException;
import io.prestosql.hadoop.$internal.org.apache.http.ProtocolVersion;
import io.prestosql.hadoop.$internal.org.apache.http.annotation.Immutable;
import io.prestosql.hadoop.$internal.org.apache.http.protocol.HttpContext;
import io.prestosql.hadoop.$internal.org.apache.http.protocol.HttpCoreContext;
import io.prestosql.hadoop.$internal.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

