/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.fast;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import java.nio.charset.StandardCharsets;

public class FastUtil {
    public static byte[] prfPlus(EncryptionKey key, String pepper, int keyBytesLen) throws KrbException {
        byte[] prfInbuf = new byte[pepper.length() + 1];
        byte[] tmpbuf = new byte[keyBytesLen];
        int prfSize = EncryptionHandler.getEncHandler(key.getKeyType()).prfSize();
        int iterations = keyBytesLen / prfSize;
        prfInbuf[0] = 1;
        System.arraycopy(pepper.getBytes(StandardCharsets.UTF_8), 0, prfInbuf, 1, pepper.length());
        if (keyBytesLen % prfSize != 0) {
            ++iterations;
        }
        byte[] buffer = new byte[prfSize * iterations];
        for (int i = 0; i < iterations; ++i) {
            System.arraycopy(EncryptionHandler.getEncHandler(key.getKeyType()).prf(key.getKeyData(), prfInbuf), 0, buffer, i * prfSize, prfSize);
            prfInbuf[0] = (byte)(prfInbuf[0] + 1);
        }
        System.arraycopy(buffer, 0, tmpbuf, 0, keyBytesLen);
        return tmpbuf;
    }

    public static EncryptionKey cf2(EncryptionKey key1, String pepper1, EncryptionKey key2, String pepper2) throws KrbException {
        int keyBites = EncryptionHandler.getEncHandler(key1.getKeyType()).encProvider().keyInputSize();
        byte[] buf1 = FastUtil.prfPlus(key1, pepper1, keyBites);
        byte[] buf2 = FastUtil.prfPlus(key2, pepper2, keyBites);
        for (int i = 0; i < keyBites; ++i) {
            int n = i;
            buf1[n] = (byte)(buf1[n] ^ buf2[i]);
        }
        EncryptionKey outKey = EncryptionHandler.random2Key(key1.getKeyType(), buf1);
        return outKey;
    }

    public static EncryptionKey makeReplyKey(EncryptionKey strengthenKey, EncryptionKey existingKey) throws KrbException {
        return FastUtil.cf2(strengthenKey, "strengthenkey", existingKey, "replykey");
    }

    public static EncryptionKey makeArmorKey(EncryptionKey subkey, EncryptionKey ticketKey) throws KrbException {
        return FastUtil.cf2(subkey, "subkeyarmor", ticketKey, "ticketarmor");
    }
}

