/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadminImpl;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.Krb5Conf;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbClient;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbConfig;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbPkinitClient;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbTokenClient;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcServer;
import io.prestosql.hadoop.$internal.org.apache.kerby.util.NetworkUtil;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;

public class SimpleKdcServer
extends KdcServer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleKdcServer.class);
    private final KrbClient krbClnt;
    private LocalKadmin kadmin;
    private Krb5Conf krb5Conf;
    private File workDir;
    private KrbPkinitClient pkinitClient;
    private KrbTokenClient tokenClient;

    public SimpleKdcServer() throws KrbException {
        this(new KrbConfig());
        this.setKdcRealm("EXAMPLE.COM");
        this.setKdcHost("localhost");
        this.setKdcPort(NetworkUtil.getServerPort());
    }

    public SimpleKdcServer(KrbConfig krbConfig) {
        this.krbClnt = new KrbClient(krbConfig);
    }

    public SimpleKdcServer(File confDir, KrbConfig krbConfig) throws KrbException {
        super(confDir);
        this.krbClnt = new KrbClient(krbConfig);
    }

    @Override
    public synchronized void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public synchronized File getWorkDir() {
        return this.workDir;
    }

    @Override
    public synchronized void setKdcRealm(String realm) {
        super.setKdcRealm(realm);
        this.krbClnt.setKdcRealm(realm);
    }

    @Override
    public synchronized void setKdcHost(String kdcHost) {
        super.setKdcHost(kdcHost);
        this.krbClnt.setKdcHost(kdcHost);
    }

    @Override
    public synchronized void setKdcTcpPort(int kdcTcpPort) {
        super.setKdcTcpPort(kdcTcpPort);
        this.krbClnt.setKdcTcpPort(kdcTcpPort);
        this.setAllowTcp(true);
    }

    @Override
    public synchronized void setAllowUdp(boolean allowUdp) {
        super.setAllowUdp(allowUdp);
        this.krbClnt.setAllowUdp(allowUdp);
    }

    @Override
    public synchronized void setAllowTcp(boolean allowTcp) {
        super.setAllowTcp(allowTcp);
        this.krbClnt.setAllowTcp(allowTcp);
    }

    @Override
    public synchronized void setKdcUdpPort(int kdcUdpPort) {
        super.setKdcUdpPort(kdcUdpPort);
        this.krbClnt.setKdcUdpPort(kdcUdpPort);
        this.setAllowUdp(true);
    }

    @Override
    public synchronized void init() throws KrbException {
        super.init();
        this.kadmin = new LocalKadminImpl(this.getKdcSetting(), this.getIdentityService());
        this.kadmin.createBuiltinPrincipals();
        try {
            this.krb5Conf = new Krb5Conf(this);
            this.krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
    }

    @Override
    public synchronized void start() throws KrbException {
        super.start();
        this.krbClnt.init();
    }

    public synchronized KrbClient getKrbClient() {
        return this.krbClnt;
    }

    public synchronized KrbPkinitClient getPkinitClient() {
        if (this.pkinitClient == null) {
            this.pkinitClient = new KrbPkinitClient(this.krbClnt);
        }
        return this.pkinitClient;
    }

    public synchronized KrbTokenClient getTokenClient() {
        if (this.tokenClient == null) {
            this.tokenClient = new KrbTokenClient(this.krbClnt);
        }
        return this.tokenClient;
    }

    public synchronized LocalKadmin getKadmin() {
        return this.kadmin;
    }

    public synchronized void createPrincipal(String principal) throws KrbException {
        this.kadmin.addPrincipal(principal);
    }

    public synchronized void createPrincipal(String principal, String password) throws KrbException {
        this.kadmin.addPrincipal(principal, password);
    }

    public synchronized void createPrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.kadmin.addPrincipal(principal);
        }
    }

    public synchronized void createAndExportPrincipals(File keytabFile, String ... principals) throws KrbException {
        this.createPrincipals(principals);
        this.exportPrincipals(keytabFile);
    }

    public synchronized void deletePrincipals(String ... principals) throws KrbException {
        for (String principal : principals) {
            this.deletePrincipal(principal);
        }
    }

    public synchronized void deletePrincipal(String principal) throws KrbException {
        this.kadmin.deletePrincipal(principal);
    }

    public synchronized void exportPrincipals(File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile);
    }

    public synchronized void exportPrincipal(String principal, File keytabFile) throws KrbException {
        this.kadmin.exportKeytab(keytabFile, principal);
    }

    @Override
    public synchronized void stop() throws KrbException {
        super.stop();
        try {
            this.krb5Conf.deleteKrb5conf();
        }
        catch (IOException e) {
            LOG.info("Fail to delete krb5 conf. " + e);
        }
    }
}

