/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.CustomDelegationTokenManager;
import org.apache.hadoop.fs.azurebfs.security.AbfsDelegationTokenIdentifier;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;

public class AbfsDelegationTokenManager {
    private CustomDelegationTokenManager tokenManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbfsDelegationTokenManager.class);

    public AbfsDelegationTokenManager(Configuration conf) throws IOException {
        Preconditions.checkNotNull(conf, "conf");
        Class<CustomDelegationTokenManager> customDelegationTokenMgrClass = conf.getClass("fs.azure.delegation.token.provider.type", null, CustomDelegationTokenManager.class);
        if (customDelegationTokenMgrClass == null) {
            throw new IllegalArgumentException("The value for \"fs.azure.delegation.token.provider.type\" is not defined.");
        }
        CustomDelegationTokenManager customTokenMgr = ReflectionUtils.newInstance(customDelegationTokenMgrClass, conf);
        if (customTokenMgr == null) {
            throw new IllegalArgumentException(String.format("Failed to initialize %s.", customDelegationTokenMgrClass));
        }
        customTokenMgr.initialize(conf);
        this.tokenManager = customTokenMgr;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> token = this.tokenManager.getDelegationToken(renewer);
        token.setKind(AbfsDelegationTokenIdentifier.TOKEN_KIND);
        return token;
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        return this.tokenManager.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        this.tokenManager.cancelDelegationToken(token);
    }
}

