/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock {
    private final ExtendedBlock b;
    private long offset;
    private final DatanodeInfoWithStorage[] locs;
    private final String[] storageIDs;
    private final StorageType[] storageTypes;
    private boolean corrupt;
    private Token<BlockTokenIdentifier> blockToken = new Token();
    private static ProvidedLastComparator providedLastComparator = new ProvidedLastComparator();
    private DatanodeInfo[] cachedLocs;
    static final DatanodeInfoWithStorage[] EMPTY_LOCS = new DatanodeInfoWithStorage[0];

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs) {
        this(b, LocatedBlock.convert(locs, null, null), (String[])null, (StorageType[])null, -1L, false, (DatanodeInfo[])EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes) {
        this(b, LocatedBlock.convert(locs, storageIDs, storageTypes), storageIDs, storageTypes, -1L, false, (DatanodeInfo[])EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes, long startOffset, boolean corrupt, DatanodeInfo[] cachedLocs) {
        this(b, LocatedBlock.convert(locs, storageIDs, storageTypes), storageIDs, storageTypes, startOffset, corrupt, null == cachedLocs || 0 == cachedLocs.length ? EMPTY_LOCS : cachedLocs);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfoWithStorage[] locs, String[] storageIDs, StorageType[] storageTypes, long startOffset, boolean corrupt, DatanodeInfo[] cachedLocs) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        this.locs = null == locs ? EMPTY_LOCS : locs;
        this.storageIDs = storageIDs;
        this.storageTypes = storageTypes;
        this.cachedLocs = null == cachedLocs || 0 == cachedLocs.length ? EMPTY_LOCS : cachedLocs;
    }

    private static DatanodeInfoWithStorage[] convert(DatanodeInfo[] infos, String[] storageIDs, StorageType[] storageTypes) {
        if (null == infos) {
            return EMPTY_LOCS;
        }
        DatanodeInfoWithStorage[] ret = new DatanodeInfoWithStorage[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            ret[i] = new DatanodeInfoWithStorage(infos[i], storageIDs != null ? storageIDs[i] : null, storageTypes != null ? storageTypes[i] : null);
        }
        return ret;
    }

    public Token<BlockTokenIdentifier> getBlockToken() {
        return this.blockToken;
    }

    public void setBlockToken(Token<BlockTokenIdentifier> token) {
        this.blockToken = token;
    }

    public ExtendedBlock getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public String[] getStorageIDs() {
        return this.storageIDs;
    }

    public void updateCachedStorageInfo() {
        int i;
        if (this.storageIDs != null) {
            for (i = 0; i < this.locs.length; ++i) {
                this.storageIDs[i] = this.locs[i].getStorageID();
            }
        }
        if (this.storageTypes != null) {
            for (i = 0; i < this.locs.length; ++i) {
                this.storageTypes[i] = this.locs[i].getStorageType();
            }
        }
    }

    public void moveProvidedToEnd(int activeLen) {
        if (activeLen <= 0) {
            return;
        }
        Arrays.sort(this.locs, 0, activeLen < this.locs.length ? activeLen : this.locs.length, providedLastComparator);
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    public void setStartOffset(long value) {
        this.offset = value;
    }

    public void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void addCachedLoc(DatanodeInfo loc) {
        ArrayList<DatanodeInfo> cachedList = Lists.newArrayList(this.cachedLocs);
        if (cachedList.contains(loc)) {
            return;
        }
        for (DatanodeInfoWithStorage di : this.locs) {
            if (!loc.equals(di)) continue;
            cachedList.add(di);
            this.cachedLocs = cachedList.toArray(this.cachedLocs);
            return;
        }
        cachedList.add(loc);
        Preconditions.checkArgument(this.cachedLocs != EMPTY_LOCS, "Cached locations should only be added when having a backing disk replica!", loc, this.locs.length, Arrays.toString(this.locs));
        this.cachedLocs = cachedList.toArray(this.cachedLocs);
    }

    public DatanodeInfo[] getCachedLocations() {
        return this.cachedLocs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "}";
    }

    public boolean isStriped() {
        return false;
    }

    public BlockType getBlockType() {
        return BlockType.CONTIGUOUS;
    }

    private static class ProvidedLastComparator
    implements Comparator<DatanodeInfoWithStorage>,
    Serializable {
        private static final long serialVersionUID = 6441720011443190984L;

        private ProvidedLastComparator() {
        }

        @Override
        public int compare(DatanodeInfoWithStorage dns1, DatanodeInfoWithStorage dns2) {
            if (StorageType.PROVIDED.equals((Object)dns1.getStorageType()) && !StorageType.PROVIDED.equals((Object)dns2.getStorageType())) {
                return 1;
            }
            if (!StorageType.PROVIDED.equals((Object)dns1.getStorageType()) && StorageType.PROVIDED.equals((Object)dns2.getStorageType())) {
                return -1;
            }
            return 0;
        }
    }
}

