/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import io.prestosql.hadoop.$internal.com.google.common.base.Joiner;
import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.collect.Maps;
import io.prestosql.hadoop.$internal.com.google.common.util.concurrent.FutureCallback;
import io.prestosql.hadoop.$internal.com.google.common.util.concurrent.Futures;
import io.prestosql.hadoop.$internal.com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.hadoop.$internal.com.google.protobuf.Message;
import io.prestosql.hadoop.$internal.com.google.protobuf.TextFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumException;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StopWatch;
import org.apache.hadoop.util.Timer;

class QuorumCall<KEY, RESULT> {
    private final Map<KEY, RESULT> successes = Maps.newHashMap();
    private final Map<KEY, Throwable> exceptions = Maps.newHashMap();
    private static final int WAIT_PROGRESS_INTERVAL_MILLIS = 1000;
    private static final float WAIT_PROGRESS_INFO_THRESHOLD = 0.3f;
    private static final float WAIT_PROGRESS_WARN_THRESHOLD = 0.7f;
    private final StopWatch quorumStopWatch;
    private final Timer timer;

    static <KEY, RESULT> QuorumCall<KEY, RESULT> create(Map<KEY, ? extends ListenableFuture<RESULT>> calls, Timer timer) {
        final QuorumCall<KEY, RESULT> qr = new QuorumCall<KEY, RESULT>(timer);
        for (final Map.Entry<KEY, ListenableFuture<RESULT>> e : calls.entrySet()) {
            Preconditions.checkArgument(e.getValue() != null, "null future for key: " + e.getKey());
            Futures.addCallback(e.getValue(), new FutureCallback<RESULT>(){

                @Override
                public void onFailure(Throwable t) {
                    qr.addException(e.getKey(), t);
                }

                @Override
                public void onSuccess(RESULT res) {
                    qr.addResult(e.getKey(), res);
                }
            });
        }
        return qr;
    }

    static <KEY, RESULT> QuorumCall<KEY, RESULT> create(Map<KEY, ? extends ListenableFuture<RESULT>> calls) {
        return QuorumCall.create(calls, new Timer());
    }

    private QuorumCall() {
        this(new Timer());
    }

    private QuorumCall(Timer timer) {
        this.timer = timer;
        this.quorumStopWatch = new StopWatch(timer);
    }

    private void restartQuorumStopWatch() {
        this.quorumStopWatch.reset().start();
    }

    private long getQuorumTimeoutIncreaseMillis(long offset, int millis) {
        long elapsed = this.quorumStopWatch.now(TimeUnit.MILLISECONDS);
        long pauseTime = elapsed + offset;
        if ((float)pauseTime > (float)millis * 0.3f) {
            QuorumJournalManager.LOG.info("Pause detected while waiting for QuorumCall response; increasing timeout threshold by pause time of " + pauseTime + " ms.");
            return pauseTime;
        }
        return -1L;
    }

    public synchronized void waitFor(int minResponses, int minSuccesses, int maxExceptions, int millis, String operationName) throws InterruptedException, TimeoutException {
        long st = this.timer.monotonicNow();
        long nextLogTime = st + (long)((float)millis * 0.3f);
        long et = st + (long)millis;
        while (true) {
            long rem;
            this.restartQuorumStopWatch();
            this.checkAssertionErrors();
            if (minResponses > 0 && this.countResponses() >= minResponses) {
                return;
            }
            if (minSuccesses > 0 && this.countSuccesses() >= minSuccesses) {
                return;
            }
            if (maxExceptions >= 0 && this.countExceptions() > maxExceptions) {
                return;
            }
            long now = this.timer.monotonicNow();
            if (now > nextLogTime) {
                long waited = now - st;
                String msg = String.format("Waited %s ms (timeout=%s ms) for a response for %s", waited, millis, operationName);
                if (!this.successes.isEmpty()) {
                    msg = msg + ". Succeeded so far: [" + Joiner.on(",").join(this.successes.keySet()) + "]";
                }
                if (!this.exceptions.isEmpty()) {
                    msg = msg + ". Exceptions so far: [" + this.getExceptionMapString() + "]";
                }
                if (this.successes.isEmpty() && this.exceptions.isEmpty()) {
                    msg = msg + ". No responses yet.";
                }
                if ((float)waited > (float)millis * 0.7f) {
                    QuorumJournalManager.LOG.warn(msg);
                } else {
                    QuorumJournalManager.LOG.info(msg);
                }
                nextLogTime = now + 1000L;
            }
            if ((rem = et - now) <= 0L) {
                long timeoutIncrease = this.getQuorumTimeoutIncreaseMillis(0L, millis);
                if (timeoutIncrease > 0L) {
                    et += timeoutIncrease;
                } else {
                    throw new TimeoutException();
                }
            }
            this.restartQuorumStopWatch();
            rem = Math.min(rem, nextLogTime - now);
            rem = Math.max(rem, 1L);
            this.wait(rem);
            long timeoutIncrease = this.getQuorumTimeoutIncreaseMillis(-rem, millis);
            if (timeoutIncrease <= 0L) continue;
            et += timeoutIncrease;
        }
    }

    private synchronized void checkAssertionErrors() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            for (Throwable t : this.exceptions.values()) {
                if (t instanceof AssertionError) {
                    throw (AssertionError)((Object)t);
                }
                if (t instanceof RemoteException && ((RemoteException)t).getClassName().equals(AssertionError.class.getName())) {
                    throw new AssertionError((Object)t);
                }
            }
        }
    }

    private synchronized void addResult(KEY k, RESULT res) {
        this.successes.put(k, res);
        this.notifyAll();
    }

    private synchronized void addException(KEY k, Throwable t) {
        this.exceptions.put(k, t);
        this.notifyAll();
    }

    public synchronized int countResponses() {
        return this.successes.size() + this.exceptions.size();
    }

    public synchronized int countSuccesses() {
        return this.successes.size();
    }

    public synchronized int countExceptions() {
        return this.exceptions.size();
    }

    public synchronized Map<KEY, RESULT> getResults() {
        return Maps.newHashMap(this.successes);
    }

    public synchronized void rethrowException(String msg) throws QuorumException {
        Preconditions.checkState(!this.exceptions.isEmpty());
        throw QuorumException.create(msg, this.successes, this.exceptions);
    }

    public static <K> String mapToString(Map<K, ? extends Message> map) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<K, Message> e : map.entrySet()) {
            if (!first) {
                sb.append("\n");
            }
            first = false;
            sb.append(e.getKey()).append(": ").append(TextFormat.shortDebugString(e.getValue()));
        }
        return sb.toString();
    }

    private String getExceptionMapString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<KEY, Throwable> e : this.exceptions.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(e.getKey()).append(": ").append(e.getValue().getLocalizedMessage());
        }
        return sb.toString();
    }
}

