/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.MoveStep;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Planner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.util.Time;

public class GreedyPlanner
implements Planner {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    private static final Logger LOG = LoggerFactory.getLogger(GreedyPlanner.class);
    private final double threshold;

    public GreedyPlanner(double threshold, DiskBalancerDataNode node) {
        this.threshold = threshold;
    }

    @Override
    public NodePlan plan(DiskBalancerDataNode node) throws Exception {
        long startTime = Time.monotonicNow();
        NodePlan plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
        LOG.info("Starting plan for Node : {}:{}", (Object)node.getDataNodeName(), (Object)node.getDataNodePort());
        while (node.isBalancingNeeded(this.threshold)) {
            for (DiskBalancerVolumeSet vSet : node.getVolumeSets().values()) {
                this.balanceVolumeSet(node, vSet, plan);
            }
        }
        long endTime = Time.monotonicNow();
        String message = String.format("Compute Plan for Node : %s:%d took %d ms ", node.getDataNodeName(), node.getDataNodePort(), endTime - startTime);
        LOG.info(message);
        return plan;
    }

    public void balanceVolumeSet(DiskBalancerDataNode node, DiskBalancerVolumeSet vSet, NodePlan plan) throws Exception {
        Preconditions.checkNotNull(vSet);
        Preconditions.checkNotNull(plan);
        Preconditions.checkNotNull(node);
        DiskBalancerVolumeSet currentSet = new DiskBalancerVolumeSet(vSet);
        while (currentSet.isBalancingNeeded(this.threshold)) {
            this.removeSkipVolumes(currentSet);
            DiskBalancerVolume lowVolume = currentSet.getSortedQueue().first();
            DiskBalancerVolume highVolume = currentSet.getSortedQueue().last();
            Step nextStep = null;
            if (!lowVolume.isSkip() && !highVolume.isSkip()) {
                nextStep = this.computeMove(currentSet, lowVolume, highVolume);
            } else {
                LOG.debug("Skipping compute move. lowVolume: {} highVolume: {}", (Object)lowVolume.getPath(), (Object)highVolume.getPath());
            }
            this.applyStep(nextStep, currentSet, lowVolume, highVolume);
            if (nextStep == null) continue;
            LOG.debug("Step : {} ", (Object)nextStep.toString());
            plan.addStep(nextStep);
        }
        String message = String.format("Disk Volume set %s Type : %s plan completed.", currentSet.getSetID(), currentSet.getVolumes().get(0).getStorageType());
        plan.setNodeName(node.getDataNodeName());
        plan.setNodeUUID(node.getDataNodeUUID());
        plan.setTimeStamp(Time.now());
        plan.setPort(node.getDataNodePort());
        LOG.info(message);
    }

    private void applyStep(Step nextStep, DiskBalancerVolumeSet currentSet, DiskBalancerVolume lowVolume, DiskBalancerVolume highVolume) throws Exception {
        if (nextStep != null) {
            long used = lowVolume.getUsed() + nextStep.getBytesToMove();
            lowVolume.setUsed(used);
            used = highVolume.getUsed() - nextStep.getBytesToMove();
            highVolume.setUsed(used);
        }
        currentSet.computeVolumeDataDensity();
        this.printQueue(currentSet.getSortedQueue());
    }

    private Step computeMove(DiskBalancerVolumeSet currentSet, DiskBalancerVolume lowVolume, DiskBalancerVolume highVolume) {
        long maxHighVolumeCanGive;
        long maxLowVolumeCanReceive = (long)(currentSet.getIdealUsed() * (double)lowVolume.computeEffectiveCapacity() - (double)lowVolume.getUsed());
        if (maxLowVolumeCanReceive <= 0L) {
            LOG.debug("{} Skipping disk from computation. Maximum data size achieved.", (Object)lowVolume.getPath());
            this.skipVolume(currentSet, lowVolume);
        }
        if ((maxHighVolumeCanGive = highVolume.getUsed() - (long)(currentSet.getIdealUsed() * (double)highVolume.computeEffectiveCapacity())) <= 0L) {
            LOG.debug(" {} Skipping disk from computation. Minimum data size achieved.", (Object)highVolume.getPath());
            this.skipVolume(currentSet, highVolume);
        }
        long bytesToMove = Math.min(maxLowVolumeCanReceive, maxHighVolumeCanGive);
        MoveStep nextStep = null;
        if (bytesToMove > 0L) {
            nextStep = new MoveStep(highVolume, currentSet.getIdealUsed(), lowVolume, bytesToMove, currentSet.getSetID());
            LOG.debug(((Object)nextStep).toString());
        }
        return nextStep;
    }

    private void skipVolume(DiskBalancerVolumeSet currentSet, DiskBalancerVolume volume) {
        if (LOG.isDebugEnabled()) {
            String message = String.format("Skipping volume. Volume : %s Type : %s Target Number of bytes : %f lowVolume dfsUsed : %d. Skipping this volume from all future balancing calls.", volume.getPath(), volume.getStorageType(), currentSet.getIdealUsed() * (double)volume.getCapacity(), volume.getUsed());
            LOG.debug(message);
        }
        volume.setSkip(true);
    }

    private void removeSkipVolumes(DiskBalancerVolumeSet currentSet) {
        List<DiskBalancerVolume> volumeList = currentSet.getVolumes();
        for (DiskBalancerVolume vol : volumeList) {
            if (!vol.isSkip() && !vol.isFailed()) continue;
            currentSet.removeVolume(vol);
        }
        currentSet.computeVolumeDataDensity();
        this.printQueue(currentSet.getSortedQueue());
    }

    private void printQueue(TreeSet<DiskBalancerVolume> queue) {
        if (LOG.isDebugEnabled()) {
            String format = String.format("First Volume : %s, DataDensity : %f, Last Volume : %s, DataDensity : %f", queue.first().getPath(), queue.first().getVolumeDataDensity(), queue.last().getPath(), queue.last().getVolumeDataDensity());
            LOG.debug(format);
        }
    }
}

