/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.CommandLine;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.HelpFormatter;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.Option;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.OptionBuilder;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.Options;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.ParseException;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.PosixParser;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointConf;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.LogsPurgeable;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NNStorageRetentionManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNodeInfoMXBean;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.hdfs.util.Canceler;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
public class SecondaryNameNode
implements Runnable,
SecondaryNameNodeInfoMXBean {
    public static final Logger LOG;
    private final long starttime = Time.now();
    private volatile long lastCheckpointTime = 0L;
    private volatile long lastCheckpointWallclockTime = 0L;
    private URL fsName;
    private CheckpointStorage checkpointImage;
    private NamenodeProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private volatile boolean shouldRun;
    private HttpServer2 infoServer;
    private Collection<URI> checkpointDirs;
    private List<URI> checkpointEditsDirs;
    private CheckpointConf checkpointConf;
    private FSNamesystem namesystem;
    private Thread checkpointThread;
    private ObjectName nameNodeStatusBeanName;
    private String legacyOivImageDir;

    public String toString() {
        return this.getClass().getSimpleName() + " Status\nName Node Address      : " + this.nameNodeAddr + "\nStart Time             : " + new Date(this.starttime) + "\nLast Checkpoint        : " + (this.lastCheckpointTime == 0L ? "--" : new Date(this.lastCheckpointWallclockTime)) + " (" + (Time.monotonicNow() - this.lastCheckpointTime) / 1000L + " seconds ago)\nCheckpoint Period      : " + this.checkpointConf.getPeriod() + " seconds\nCheckpoint Transactions: " + this.checkpointConf.getTxnCount() + "\nCheckpoint Dirs        : " + this.checkpointDirs + "\nCheckpoint Edits Dirs  : " + this.checkpointEditsDirs;
    }

    @VisibleForTesting
    FSImage getFSImage() {
        return this.checkpointImage;
    }

    @VisibleForTesting
    int getMergeErrorCount() {
        return this.checkpointImage.getMergeErrorCount();
    }

    @VisibleForTesting
    public FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    @VisibleForTesting
    void setFSImage(CheckpointStorage image) {
        this.checkpointImage = image;
    }

    @VisibleForTesting
    NamenodeProtocol getNameNode() {
        return this.namenode;
    }

    @VisibleForTesting
    void setNameNode(NamenodeProtocol namenode) {
        this.namenode = namenode;
    }

    public SecondaryNameNode(Configuration conf) throws IOException {
        this(conf, new CommandLineOpts());
    }

    public SecondaryNameNode(Configuration conf, CommandLineOpts commandLineOpts) throws IOException {
        try {
            String nsId = DFSUtil.getSecondaryNameServiceId(conf);
            if (HAUtil.isHAEnabled(conf, nsId)) {
                throw new IOException("Cannot use SecondaryNameNode in an HA cluster. The Standby Namenode will perform checkpointing.");
            }
            NameNode.initializeGenericKeys(conf, nsId, null);
            this.initialize(conf, commandLineOpts);
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        catch (HadoopIllegalArgumentException e) {
            this.shutdown();
            throw e;
        }
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr(conf.getTrimmed("dfs.namenode.secondary.http-address", "0.0.0.0:9868"));
    }

    private void initialize(Configuration conf, CommandLineOpts commandLineOpts) throws IOException {
        InetSocketAddress infoSocAddr = SecondaryNameNode.getHttpAddress(conf);
        String infoBindAddress = infoSocAddr.getHostName();
        UserGroupInformation.setConfiguration(conf);
        if (UserGroupInformation.isSecurityEnabled()) {
            SecurityUtil.login(conf, "dfs.secondary.namenode.keytab.file", "dfs.secondary.namenode.kerberos.principal", infoBindAddress);
        }
        DefaultMetricsSystem.initialize("SecondaryNameNode");
        JvmMetrics.create("SecondaryNameNode", conf.get("dfs.metrics.session-id"), DefaultMetricsSystem.instance());
        this.shouldRun = true;
        this.nameNodeAddr = NameNode.getServiceAddress(conf, true);
        this.conf = conf;
        this.namenode = NameNodeProxies.createNonHAProxy(conf, this.nameNodeAddr, NamenodeProtocol.class, UserGroupInformation.getCurrentUser(), true).getProxy();
        this.fsName = this.getInfoServer();
        this.checkpointDirs = FSImage.getCheckpointDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointEditsDirs = FSImage.getCheckpointEditsDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointImage = new CheckpointStorage(conf, this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointImage.recoverCreate(commandLineOpts.shouldFormat());
        this.checkpointImage.deleteTempEdits();
        this.namesystem = new FSNamesystem(conf, this.checkpointImage, true);
        this.namesystem.dir.disableQuotaChecks();
        this.checkpointConf = new CheckpointConf(conf);
        this.nameNodeStatusBeanName = MBeans.register("SecondaryNameNode", "SecondaryNameNodeInfo", this);
        this.legacyOivImageDir = conf.get("dfs.namenode.legacy-oiv-image.dir");
        LOG.info("Checkpoint Period   :" + this.checkpointConf.getPeriod() + " secs (" + this.checkpointConf.getPeriod() / 60L + " min)");
        LOG.info("Log Size Trigger    :" + this.checkpointConf.getTxnCount() + " txns");
    }

    private void join() {
        try {
            this.infoServer.join();
        }
        catch (InterruptedException ie) {
            LOG.debug("Exception ", ie);
        }
    }

    public void shutdown() {
        this.shouldRun = false;
        if (this.checkpointThread != null) {
            this.checkpointThread.interrupt();
            try {
                this.checkpointThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted waiting to join on checkpointer thread");
                Thread.currentThread().interrupt();
            }
        }
        try {
            if (this.infoServer != null) {
                this.infoServer.stop();
                this.infoServer = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception shutting down SecondaryNameNode", e);
        }
        if (this.nameNodeStatusBeanName != null) {
            MBeans.unregister(this.nameNodeStatusBeanName);
            this.nameNodeStatusBeanName = null;
        }
        try {
            if (this.checkpointImage != null) {
                this.checkpointImage.close();
                this.checkpointImage = null;
            }
        }
        catch (IOException e) {
            LOG.warn("Exception while closing CheckpointStorage", e);
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
            this.namesystem = null;
        }
    }

    @Override
    public void run() {
        SecurityUtil.doAsLoginUserOrFatal(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecondaryNameNode.this.doWork();
                return null;
            }
        });
    }

    public void doWork() {
        long period = this.checkpointConf.getCheckPeriod();
        int maxRetries = this.checkpointConf.getMaxRetriesOnMergeError();
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                if (UserGroupInformation.isSecurityEnabled()) {
                    UserGroupInformation.getCurrentUser().checkTGTAndReloginFromKeytab();
                }
                long monotonicNow = Time.monotonicNow();
                long now = Time.now();
                if (!this.shouldCheckpointBasedOnCount() && monotonicNow < this.lastCheckpointTime + 1000L * this.checkpointConf.getPeriod()) continue;
                this.doCheckpoint();
                this.lastCheckpointTime = monotonicNow;
                this.lastCheckpointWallclockTime = now;
            }
            catch (IOException e) {
                LOG.error("Exception in doCheckpoint", e);
                e.printStackTrace();
                if (this.checkpointImage.getMergeErrorCount() <= maxRetries) continue;
                LOG.error("Merging failed " + this.checkpointImage.getMergeErrorCount() + " times.");
                ExitUtil.terminate(1);
            }
            catch (Throwable e) {
                LOG.error("Throwable Exception in doCheckpoint", e);
                e.printStackTrace();
                ExitUtil.terminate(1, e);
            }
        }
    }

    static boolean downloadCheckpointFiles(final URL nnHostPort, final FSImage dstImage, final CheckpointSignature sig, final RemoteEditLogManifest manifest) throws IOException {
        if (manifest.getLogs().isEmpty()) {
            throw new IOException("Found no edit logs to download on NN since txid " + sig.mostRecentCheckpointTxId);
        }
        long expectedTxId = sig.mostRecentCheckpointTxId + 1L;
        if (manifest.getLogs().get(0).getStartTxId() != expectedTxId) {
            throw new IOException("Bad edit log manifest (expected txid = " + expectedTxId + ": " + manifest);
        }
        try {
            Boolean b = UserGroupInformation.getCurrentUser().doAs(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    dstImage.getStorage().cTime = sig.cTime;
                    if (sig.mostRecentCheckpointTxId == dstImage.getStorage().getMostRecentCheckpointTxId()) {
                        LOG.info("Image has not changed. Will not download image.");
                    } else {
                        LOG.info("Image has changed. Downloading updated image from NN.");
                        MD5Hash downloadedHash = TransferFsImage.downloadImageToStorage(nnHostPort, sig.mostRecentCheckpointTxId, dstImage.getStorage(), true, false);
                        dstImage.saveDigestAndRenameCheckpointImage(NNStorage.NameNodeFile.IMAGE, sig.mostRecentCheckpointTxId, downloadedHash);
                    }
                    for (RemoteEditLog log : manifest.getLogs()) {
                        TransferFsImage.downloadEditsToStorage(nnHostPort, log, dstImage.getStorage());
                    }
                    return dstImage.getLastAppliedTxId() < sig.mostRecentCheckpointTxId;
                }
            });
            return b;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    InetSocketAddress getNameNodeAddress() {
        return this.nameNodeAddr;
    }

    private URL getInfoServer() throws IOException {
        URI fsName = FileSystem.getDefaultUri(this.conf);
        if (!"hdfs".equalsIgnoreCase(fsName.getScheme())) {
            throw new IOException("This is not a DFS");
        }
        String scheme = DFSUtil.getHttpClientScheme(this.conf);
        URI address = DFSUtil.getInfoServerWithDefaultHost(fsName.getHost(), this.conf, scheme);
        LOG.debug("Will connect to NameNode at " + address);
        return address.toURL();
    }

    @VisibleForTesting
    public void startInfoServer() throws IOException {
        InetSocketAddress httpAddr = SecondaryNameNode.getHttpAddress(this.conf);
        String httpsAddrString = this.conf.getTrimmed("dfs.namenode.secondary.https-address", "0.0.0.0:9869");
        InetSocketAddress httpsAddr = NetUtils.createSocketAddr(httpsAddrString);
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN(this.conf, httpAddr, httpsAddr, "secondary", "dfs.secondary.namenode.kerberos.internal.spnego.principal", "dfs.secondary.namenode.keytab.file");
        boolean xFrameEnabled = this.conf.getBoolean("dfs.xframe.enabled", true);
        String xFrameOptionValue = this.conf.getTrimmed("dfs.xframe.value", "SAMEORIGIN");
        builder.configureXFrame(xFrameEnabled).setXFrameOption(xFrameOptionValue);
        this.infoServer = builder.build();
        this.infoServer.setAttribute("secondary.name.node", this);
        this.infoServer.setAttribute("name.system.image", this.checkpointImage);
        this.infoServer.setAttribute("current.conf", this.conf);
        this.infoServer.addInternalServlet("imagetransfer", "/imagetransfer", ImageServlet.class, true);
        this.infoServer.start();
        LOG.info("Web server init done");
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(this.conf);
        int connIdx = 0;
        if (policy.isHttpEnabled()) {
            InetSocketAddress httpAddress = this.infoServer.getConnectorAddress(connIdx++);
            this.conf.set("dfs.namenode.secondary.http-address", NetUtils.getHostPortString(httpAddress));
        }
        if (policy.isHttpsEnabled()) {
            InetSocketAddress httpsAddress = this.infoServer.getConnectorAddress(connIdx);
            this.conf.set("dfs.namenode.secondary.https-address", NetUtils.getHostPortString(httpsAddress));
        }
    }

    @VisibleForTesting
    public boolean doCheckpoint() throws IOException {
        boolean isSameCluster;
        this.checkpointImage.ensureCurrentDirExists();
        NNStorage dstStorage = this.checkpointImage.getStorage();
        CheckpointSignature sig = this.namenode.rollEditLog();
        boolean loadImage = false;
        boolean isFreshCheckpointer = this.checkpointImage.getNamespaceID() == 0;
        boolean bl = isSameCluster = dstStorage.versionSupportsFederation(NameNodeLayoutVersion.FEATURES) && sig.isSameCluster(this.checkpointImage) || !dstStorage.versionSupportsFederation(NameNodeLayoutVersion.FEATURES) && sig.namespaceIdMatches(this.checkpointImage);
        if (isFreshCheckpointer || isSameCluster && !sig.storageVersionMatches(this.checkpointImage.getStorage())) {
            dstStorage.setStorageInfo(sig);
            dstStorage.setClusterID(sig.getClusterID());
            dstStorage.setBlockPoolID(sig.getBlockpoolID());
            loadImage = true;
        }
        sig.validateStorageInfo(this.checkpointImage);
        CheckpointFaultInjector.getInstance().afterSecondaryCallsRollEditLog();
        RemoteEditLogManifest manifest = this.namenode.getEditLogManifest(sig.mostRecentCheckpointTxId + 1L);
        loadImage |= SecondaryNameNode.downloadCheckpointFiles(this.fsName, this.checkpointImage, sig, manifest) | this.checkpointImage.hasMergeError();
        try {
            this.doMerge(sig, manifest, loadImage, this.checkpointImage, this.namesystem);
        }
        catch (IOException ioe) {
            this.checkpointImage.setMergeError();
            throw ioe;
        }
        this.checkpointImage.clearMergeError();
        long txid = this.checkpointImage.getLastAppliedTxId();
        TransferFsImage.uploadImageFromStorage(this.fsName, this.conf, dstStorage, NNStorage.NameNodeFile.IMAGE, txid);
        CheckpointFaultInjector.getInstance().afterSecondaryUploadsNewImage();
        LOG.warn("Checkpoint done. New Image Size: " + dstStorage.getFsImageName(txid).length());
        if (this.legacyOivImageDir != null && !this.legacyOivImageDir.isEmpty()) {
            try {
                this.checkpointImage.saveLegacyOIVImage(this.namesystem, this.legacyOivImageDir, new Canceler());
            }
            catch (IOException e) {
                LOG.warn("Failed to write legacy OIV image: ", e);
            }
        }
        return loadImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processStartupCommand(CommandLineOpts opts) throws Exception {
        if (opts.getCommand() == null) {
            return 0;
        }
        String cmd = StringUtils.toLowerCase(opts.getCommand().toString());
        int exitCode = 0;
        try {
            switch (opts.getCommand()) {
                case CHECKPOINT: {
                    long count = this.countUncheckpointedTxns();
                    if (count > this.checkpointConf.getTxnCount() || opts.shouldForceCheckpoint()) {
                        this.doCheckpoint();
                        break;
                    }
                    System.err.println("EditLog size " + count + " transactions is smaller than configured checkpoint interval " + this.checkpointConf.getTxnCount() + " transactions.");
                    System.err.println("Skipping checkpoint.");
                    break;
                }
                case GETEDITSIZE: {
                    long uncheckpointed = this.countUncheckpointedTxns();
                    System.out.println("NameNode has " + uncheckpointed + " uncheckpointed transactions");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("bad command enum: " + (Object)((Object)opts.getCommand())));
                }
            }
        }
        catch (RemoteException e) {
            exitCode = 1;
            try {
                String[] content = e.getLocalizedMessage().split("\n");
                LOG.error(cmd + ": " + content[0]);
            }
            catch (Exception ex) {
                LOG.error(cmd + ": " + ex.getLocalizedMessage());
            }
        }
        catch (IOException e) {
            exitCode = 1;
            LOG.error(cmd + ": " + e.getLocalizedMessage());
        }
        return exitCode;
    }

    private long countUncheckpointedTxns() throws IOException {
        long curTxId = this.namenode.getTransactionID();
        long uncheckpointedTxns = curTxId - this.checkpointImage.getStorage().getMostRecentCheckpointTxId();
        assert (uncheckpointedTxns >= 0L);
        return uncheckpointedTxns;
    }

    boolean shouldCheckpointBasedOnCount() throws IOException {
        return this.countUncheckpointedTxns() >= this.checkpointConf.getTxnCount();
    }

    public static void main(String[] argv) throws Exception {
        CommandLineOpts opts = SecondaryNameNode.parseArgs(argv);
        if (opts == null) {
            LOG.error("Failed to parse options");
            ExitUtil.terminate(1);
        } else if (opts.shouldPrintHelp()) {
            opts.usage();
            System.exit(0);
        }
        try {
            StringUtils.startupShutdownMessage(SecondaryNameNode.class, argv, LOG);
            HdfsConfiguration tconf = new HdfsConfiguration();
            SecondaryNameNode secondary = null;
            secondary = new SecondaryNameNode(tconf, opts);
            if (opts != null && opts.getCommand() != null) {
                int ret = secondary.processStartupCommand(opts);
                ExitUtil.terminate(ret);
            } else {
                secondary.startInfoServer();
                secondary.startCheckpointThread();
                secondary.join();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to start secondary namenode", e);
            ExitUtil.terminate(1);
        }
    }

    public void startCheckpointThread() {
        Preconditions.checkState(this.checkpointThread == null, "Should not already have a thread");
        Preconditions.checkState(this.shouldRun, "shouldRun should be true");
        this.checkpointThread = new Daemon(this);
        this.checkpointThread.start();
    }

    @Override
    public String getHostAndPort() {
        return NetUtils.getHostPortString(this.nameNodeAddr);
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public long getStartTime() {
        return this.starttime;
    }

    @Override
    public long getLastCheckpointTime() {
        return this.lastCheckpointWallclockTime;
    }

    @Override
    public long getLastCheckpointDeltaMs() {
        if (this.lastCheckpointTime == 0L) {
            return -1L;
        }
        return Time.monotonicNow() - this.lastCheckpointTime;
    }

    @Override
    public String[] getCheckpointDirectories() {
        ArrayList<String> r = Lists.newArrayListWithCapacity(this.checkpointDirs.size());
        for (URI d : this.checkpointDirs) {
            r.add(d.toString());
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    public String[] getCheckpointEditlogDirectories() {
        ArrayList<String> r = Lists.newArrayListWithCapacity(this.checkpointEditsDirs.size());
        for (URI d : this.checkpointEditsDirs) {
            r.add(d.toString());
        }
        return r.toArray(new String[r.size()]);
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    private static CommandLineOpts parseArgs(String[] argv) {
        CommandLineOpts opts = new CommandLineOpts();
        try {
            opts.parse(argv);
        }
        catch (ParseException pe) {
            LOG.error(pe.getMessage());
            opts.usage();
            return null;
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doMerge(CheckpointSignature sig, RemoteEditLogManifest manifest, boolean loadImage, FSImage dstImage, FSNamesystem dstNamesystem) throws IOException {
        NNStorage dstStorage = dstImage.getStorage();
        dstStorage.setStorageInfo(sig);
        if (loadImage) {
            File file = dstStorage.findImageFile(NNStorage.NameNodeFile.IMAGE, sig.mostRecentCheckpointTxId);
            if (file == null) {
                throw new IOException("Couldn't find image file at txid " + sig.mostRecentCheckpointTxId + " even though it should have just been downloaded");
            }
            dstNamesystem.writeLock();
            try {
                dstImage.reloadFromImageFile(file, dstNamesystem);
            }
            finally {
                dstNamesystem.writeUnlock();
            }
            dstNamesystem.imageLoadComplete();
        }
        CheckpointFaultInjector.getInstance().duringMerge();
        Checkpointer.rollForwardByApplyingLogs(manifest, dstImage, dstNamesystem);
        dstImage.saveFSImageInAllDirs(dstNamesystem, dstImage.getLastAppliedTxId());
        if (!this.namenode.isRollingUpgrade()) {
            dstImage.updateStorageVersion();
        }
    }

    static {
        HdfsConfiguration.init();
        LOG = LoggerFactory.getLogger(SecondaryNameNode.class.getName());
    }

    static class CheckpointStorage
    extends FSImage {
        private int mergeErrorCount;

        CheckpointStorage(Configuration conf, Collection<URI> imageDirs, List<URI> editsDirs) throws IOException {
            super(conf, imageDirs, editsDirs);
            this.editLog = null;
            this.mergeErrorCount = 0;
            this.archivalManager = new NNStorageRetentionManager(conf, this.storage, new CheckpointLogPurger(this.storage));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recoverCreate(boolean format) throws IOException {
            this.storage.attemptRestoreRemovedStorage();
            this.storage.unlockAll();
            Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
            block9: while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                boolean isAccessible = true;
                try {
                    if (sd.getRoot().mkdirs()) {
                        // empty if block
                    }
                }
                catch (SecurityException se) {
                    isAccessible = false;
                }
                if (!isAccessible) {
                    throw new InconsistentFSStateException(sd.getRoot(), "cannot access checkpoint directory.");
                }
                if (format) {
                    LOG.info("Formatting storage directory " + sd);
                    sd.clearDirectory();
                }
                try {
                    Storage.StorageState curState = sd.analyzeStorage(HdfsServerConstants.StartupOption.REGULAR, this.storage);
                    switch (curState) {
                        case NON_EXISTENT: {
                            throw new InconsistentFSStateException(sd.getRoot(), "checkpoint directory does not exist or is not accessible.");
                        }
                        case NOT_FORMATTED: {
                            continue block9;
                        }
                        case NORMAL: {
                            this.storage.readProperties(sd);
                            continue block9;
                        }
                    }
                    sd.doRecover(curState);
                }
                catch (IOException ioe) {
                    sd.unlock();
                    throw ioe;
                }
            }
            return;
        }

        boolean hasMergeError() {
            return this.mergeErrorCount > 0;
        }

        int getMergeErrorCount() {
            return this.mergeErrorCount;
        }

        void setMergeError() {
            ++this.mergeErrorCount;
        }

        void clearMergeError() {
            this.mergeErrorCount = 0;
        }

        void ensureCurrentDirExists() throws IOException {
            Iterator<Storage.StorageDirectory> it = this.storage.dirIterator();
            while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                File curDir = sd.getCurrentDir();
                if (curDir.exists() || curDir.mkdirs()) continue;
                throw new IOException("Could not create directory " + curDir);
            }
        }

        void deleteTempEdits() throws IOException {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(NNStorage.NameNodeFile.EDITS_TMP.getName() + "_(\\d+)-(\\d+)_(\\d+)");
                }
            };
            Iterator<Storage.StorageDirectory> it = this.storage.dirIterator(NNStorage.NameNodeDirType.EDITS);
            while (it.hasNext()) {
                Storage.StorageDirectory dir = it.next();
                File[] tempEdits = dir.getCurrentDir().listFiles(filter);
                if (tempEdits == null) continue;
                for (File t : tempEdits) {
                    boolean success = t.delete();
                    if (success) continue;
                    LOG.warn("Failed to delete temporary edits file: " + t.getAbsolutePath());
                }
            }
        }

        private static class CheckpointLogPurger
        implements LogsPurgeable {
            private final NNStorage storage;
            private final NNStorageRetentionManager.StoragePurger purger = new NNStorageRetentionManager.DeletionStoragePurger();

            public CheckpointLogPurger(NNStorage storage) {
                this.storage = storage;
            }

            @Override
            public void purgeLogsOlderThan(long minTxIdToKeep) throws IOException {
                Iterator<Storage.StorageDirectory> iter = this.storage.dirIterator();
                while (iter.hasNext()) {
                    Storage.StorageDirectory dir = iter.next();
                    List<FileJournalManager.EditLogFile> editFiles = FileJournalManager.matchEditLogs(dir.getCurrentDir());
                    for (FileJournalManager.EditLogFile f : editFiles) {
                        if (f.getLastTxId() >= minTxIdToKeep) continue;
                        this.purger.purgeLog(f);
                    }
                }
            }

            @Override
            public void selectInputStreams(Collection<EditLogInputStream> streams, long fromTxId, boolean inProgressOk, boolean onlyDurableTxns) {
                Iterator<Storage.StorageDirectory> iter = this.storage.dirIterator();
                while (iter.hasNext()) {
                    List<FileJournalManager.EditLogFile> editFiles;
                    Storage.StorageDirectory dir = iter.next();
                    try {
                        editFiles = FileJournalManager.matchEditLogs(dir.getCurrentDir());
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                    FileJournalManager.addStreamsToCollectionFromFiles(editFiles, streams, fromTxId, Long.MAX_VALUE, inProgressOk);
                }
            }
        }
    }

    static class CommandLineOpts {
        private final Options options = new Options();
        private final Option geteditsizeOpt = new Option("geteditsize", "return the number of uncheckpointed transactions on the NameNode");
        private final Option checkpointOpt;
        private final Option formatOpt;
        private final Option helpOpt;
        Command cmd;
        private boolean shouldForce;
        private boolean shouldFormat;
        private boolean shouldPrintHelp;

        CommandLineOpts() {
            OptionBuilder.withArgName("force");
            OptionBuilder.hasOptionalArg();
            OptionBuilder.withDescription("checkpoint on startup");
            this.checkpointOpt = OptionBuilder.create("checkpoint");
            this.formatOpt = new Option("format", "format the local storage during startup");
            this.helpOpt = new Option("h", "help", false, "get help information");
            this.options.addOption(this.geteditsizeOpt);
            this.options.addOption(this.checkpointOpt);
            this.options.addOption(this.formatOpt);
            this.options.addOption(this.helpOpt);
        }

        public boolean shouldFormat() {
            return this.shouldFormat;
        }

        public boolean shouldPrintHelp() {
            return this.shouldPrintHelp;
        }

        public void parse(String ... argv) throws ParseException {
            PosixParser parser = new PosixParser();
            CommandLine cmdLine = parser.parse(this.options, argv);
            if (cmdLine.hasOption(this.helpOpt.getOpt()) || cmdLine.hasOption(this.helpOpt.getLongOpt())) {
                this.shouldPrintHelp = true;
                return;
            }
            boolean hasGetEdit = cmdLine.hasOption(this.geteditsizeOpt.getOpt());
            boolean hasCheckpoint = cmdLine.hasOption(this.checkpointOpt.getOpt());
            if (hasGetEdit && hasCheckpoint) {
                throw new ParseException("May not pass both " + this.geteditsizeOpt.getOpt() + " and " + this.checkpointOpt.getOpt());
            }
            if (hasGetEdit) {
                this.cmd = Command.GETEDITSIZE;
            } else if (hasCheckpoint) {
                this.cmd = Command.CHECKPOINT;
                String arg = cmdLine.getOptionValue(this.checkpointOpt.getOpt());
                if ("force".equals(arg)) {
                    this.shouldForce = true;
                } else if (arg != null) {
                    throw new ParseException("-checkpoint may only take 'force' as an argument");
                }
            }
            if (cmdLine.hasOption(this.formatOpt.getOpt())) {
                this.shouldFormat = true;
            }
        }

        public Command getCommand() {
            return this.cmd;
        }

        public boolean shouldForceCheckpoint() {
            return this.shouldForce;
        }

        void usage() {
            String header = "The Secondary NameNode is a helper to the primary NameNode. The Secondary is responsible for supporting periodic checkpoints of the HDFS metadata. The current design allows only one Secondary NameNode per HDFS cluster.";
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("secondarynamenode", header, this.options, "", false);
        }

        static enum Command {
            GETEDITSIZE,
            CHECKPOINT;

        }
    }
}

