/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.ContentCounts;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotDiffInfo;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotDiffListingInfo;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DirectorySnapshottableFeature
extends DirectoryWithSnapshotFeature {
    static final int SNAPSHOT_QUOTA_DEFAULT = 65536;
    private final List<Snapshot> snapshotsByNames = new ArrayList<Snapshot>();
    private int snapshotQuota = 65536;

    public DirectorySnapshottableFeature(DirectoryWithSnapshotFeature feature) {
        super(feature == null ? null : feature.getDiffs());
    }

    public int getNumSnapshots() {
        return this.snapshotsByNames.size();
    }

    private int searchSnapshot(byte[] snapshotName) {
        return Collections.binarySearch(this.snapshotsByNames, snapshotName);
    }

    public Snapshot getSnapshot(byte[] snapshotName) {
        int i = this.searchSnapshot(snapshotName);
        return i < 0 ? null : this.snapshotsByNames.get(i);
    }

    public Snapshot getSnapshotById(int sid) {
        for (Snapshot s : this.snapshotsByNames) {
            if (s.getId() != sid) continue;
            return s;
        }
        return null;
    }

    public ReadOnlyList<Snapshot> getSnapshotList() {
        return ReadOnlyList.Util.asReadOnlyList(this.snapshotsByNames);
    }

    public void renameSnapshot(String path, String oldName, String newName) throws SnapshotException {
        int indexOfOld = this.searchSnapshot(DFSUtil.string2Bytes(oldName));
        if (indexOfOld < 0) {
            throw new SnapshotException("The snapshot " + oldName + " does not exist for directory " + path);
        }
        if (newName.equals(oldName)) {
            return;
        }
        byte[] newNameBytes = DFSUtil.string2Bytes(newName);
        int indexOfNew = this.searchSnapshot(newNameBytes);
        if (indexOfNew >= 0) {
            throw new SnapshotException("The snapshot " + newName + " already exists for directory " + path);
        }
        Snapshot snapshot = this.snapshotsByNames.remove(indexOfOld);
        Snapshot.Root ssRoot = snapshot.getRoot();
        ssRoot.setLocalName(newNameBytes);
        indexOfNew = -indexOfNew - 1;
        if (indexOfNew <= indexOfOld) {
            this.snapshotsByNames.add(indexOfNew, snapshot);
        } else {
            this.snapshotsByNames.add(indexOfNew - 1, snapshot);
        }
    }

    public int getSnapshotQuota() {
        return this.snapshotQuota;
    }

    public void setSnapshotQuota(int snapshotQuota) {
        if (snapshotQuota < 0) {
            throw new HadoopIllegalArgumentException("Cannot set snapshot quota to " + snapshotQuota + " < 0");
        }
        this.snapshotQuota = snapshotQuota;
    }

    void addSnapshot(Snapshot snapshot) {
        this.snapshotsByNames.add(snapshot);
    }

    public Snapshot addSnapshot(INodeDirectory snapshotRoot, int id, String name, LeaseManager leaseManager, boolean captureOpenFiles, int maxSnapshotLimit) throws SnapshotException {
        int n = this.getNumSnapshots();
        if (n + 1 > this.snapshotQuota) {
            throw new SnapshotException("Failed to add snapshot: there are already " + n + " snapshot(s) and the snapshot quota is " + this.snapshotQuota);
        }
        if (n + 1 > maxSnapshotLimit) {
            throw new SnapshotException("Failed to add snapshot: there are already " + n + " snapshot(s) and the max snapshot limit is " + maxSnapshotLimit);
        }
        Snapshot s = new Snapshot(id, name, snapshotRoot);
        byte[] nameBytes = s.getRoot().getLocalNameBytes();
        int i = this.searchSnapshot(nameBytes);
        if (i >= 0) {
            throw new SnapshotException("Failed to add snapshot: there is already a snapshot with the same name \"" + Snapshot.getSnapshotName(s) + "\".");
        }
        DirectoryWithSnapshotFeature.DirectoryDiff d = (DirectoryWithSnapshotFeature.DirectoryDiff)this.getDiffs().addDiff(id, snapshotRoot);
        d.setSnapshotRoot(s.getRoot());
        this.snapshotsByNames.add(-i - 1, s);
        long now = Time.now();
        snapshotRoot.updateModificationTime(now, 0x7FFFFFFE);
        s.getRoot().setModificationTime(now, 0x7FFFFFFE);
        if (captureOpenFiles) {
            try {
                Set<INodesInPath> openFilesIIP = leaseManager.getINodeWithLeases(snapshotRoot);
                for (INodesInPath openFileIIP : openFilesIIP) {
                    INodeFile openFile = openFileIIP.getLastINode().asFile();
                    openFile.recordModification(openFileIIP.getLatestSnapshotId());
                }
            }
            catch (Exception e) {
                throw new SnapshotException("Failed to add snapshot: Unable to capture all open files under the snapshot dir " + snapshotRoot.getFullPathName() + " for snapshot '" + name + "'", e);
            }
        }
        return s;
    }

    public Snapshot removeSnapshot(INode.ReclaimContext reclaimContext, INodeDirectory snapshotRoot, String snapshotName) throws SnapshotException {
        int i = this.searchSnapshot(DFSUtil.string2Bytes(snapshotName));
        if (i < 0) {
            throw new SnapshotException("Cannot delete snapshot " + snapshotName + " from path " + snapshotRoot.getFullPathName() + ": the snapshot does not exist.");
        }
        Snapshot snapshot = this.snapshotsByNames.get(i);
        int prior = Snapshot.findLatestSnapshot(snapshotRoot, snapshot.getId());
        snapshotRoot.cleanSubtree(reclaimContext, snapshot.getId(), prior);
        this.snapshotsByNames.remove(i);
        return snapshot;
    }

    @Override
    public void computeContentSummary4Snapshot(BlockStoragePolicySuite bsps, ContentCounts counts) throws AccessControlException {
        counts.addContent(Content.SNAPSHOT, this.snapshotsByNames.size());
        counts.addContent(Content.SNAPSHOTTABLE_DIRECTORY, 1L);
        super.computeContentSummary4Snapshot(bsps, counts);
    }

    SnapshotDiffInfo computeDiff(INodeDirectory snapshotRootDir, INodeDirectory snapshotDiffScopeDir, String from, String to) throws SnapshotException {
        Preconditions.checkArgument(snapshotDiffScopeDir.isDescendantOfSnapshotRoot(snapshotRootDir));
        Snapshot fromSnapshot = this.getSnapshotByName(snapshotRootDir, from);
        Snapshot toSnapshot = this.getSnapshotByName(snapshotRootDir, to);
        if (from != null && from.equals(to)) {
            return null;
        }
        SnapshotDiffInfo diffs = new SnapshotDiffInfo(snapshotRootDir, snapshotDiffScopeDir, fromSnapshot, toSnapshot);
        this.computeDiffRecursively(snapshotDiffScopeDir, snapshotDiffScopeDir, new ArrayList<byte[]>(), diffs);
        return diffs;
    }

    SnapshotDiffListingInfo computeDiff(INodeDirectory snapshotRootDir, INodeDirectory snapshotDiffScopeDir, String from, String to, byte[] startPath, int index, int snapshotDiffReportEntriesLimit) throws SnapshotException {
        Preconditions.checkArgument(snapshotDiffScopeDir.isDescendantOfSnapshotRoot(snapshotRootDir));
        Snapshot fromSnapshot = this.getSnapshotByName(snapshotRootDir, from);
        Snapshot toSnapshot = this.getSnapshotByName(snapshotRootDir, to);
        boolean toProcess = Arrays.equals(startPath, DFSUtilClient.EMPTY_BYTES);
        byte[][] resumePath = DFSUtilClient.bytes2byteArray(startPath);
        if (from.equals(to)) {
            return null;
        }
        SnapshotDiffListingInfo diffs = new SnapshotDiffListingInfo(snapshotRootDir, snapshotDiffScopeDir, fromSnapshot, toSnapshot, snapshotDiffReportEntriesLimit);
        diffs.setLastIndex(index);
        this.computeDiffRecursively(snapshotDiffScopeDir, snapshotDiffScopeDir, new ArrayList<byte[]>(), diffs, resumePath, 0, toProcess);
        return diffs;
    }

    private Snapshot getSnapshotByName(INodeDirectory snapshotRoot, String snapshotName) throws SnapshotException {
        Snapshot s = null;
        if (snapshotName != null && !snapshotName.isEmpty()) {
            int index = this.searchSnapshot(DFSUtil.string2Bytes(snapshotName));
            if (index < 0) {
                throw new SnapshotException("Cannot find the snapshot of directory " + snapshotRoot.getFullPathName() + " with name " + snapshotName);
            }
            s = this.snapshotsByNames.get(index);
        }
        return s;
    }

    private void computeDiffRecursively(INodeDirectory snapshotDir, INode node, List<byte[]> parentPath, SnapshotDiffInfo diffReport) {
        INodeFile file;
        boolean change;
        Snapshot earlierSnapshot = diffReport.isFromEarlier() ? diffReport.getFrom() : diffReport.getTo();
        Snapshot laterSnapshot = diffReport.isFromEarlier() ? diffReport.getTo() : diffReport.getFrom();
        byte[][] relativePath = (byte[][])parentPath.toArray((T[])new byte[parentPath.size()][]);
        if (node.isDirectory()) {
            boolean change2;
            DirectoryWithSnapshotFeature.ChildrenDiff diff = new DirectoryWithSnapshotFeature.ChildrenDiff();
            INodeDirectory dir = node.asDirectory();
            DirectoryWithSnapshotFeature sf = dir.getDirectoryWithSnapshotFeature();
            if (sf != null && (change2 = sf.computeDiffBetweenSnapshots(earlierSnapshot, laterSnapshot, diff, dir))) {
                diffReport.addDirDiff(dir, relativePath, diff);
            }
            ReadOnlyList<INode> children = dir.getChildrenList(earlierSnapshot.getId());
            for (INode child : children) {
                byte[][] renameTargetPath;
                boolean toProcess;
                byte[] name = child.getLocalNameBytes();
                boolean bl = toProcess = !diff.containsDeleted(name);
                if (!toProcess && child instanceof INodeReference.WithName && (renameTargetPath = this.findRenameTargetPath(snapshotDir, (INodeReference.WithName)child, laterSnapshot == null ? 0x7FFFFFFE : laterSnapshot.getId())) != null) {
                    toProcess = true;
                    diffReport.setRenameTarget(child.getId(), renameTargetPath);
                }
                if (!toProcess) continue;
                parentPath.add(name);
                this.computeDiffRecursively(snapshotDir, child, parentPath, diffReport);
                parentPath.remove(parentPath.size() - 1);
            }
        } else if (node.isFile() && node.asFile().isWithSnapshot() && (change = (file = node.asFile()).getFileWithSnapshotFeature().changedBetweenSnapshots(file, earlierSnapshot, laterSnapshot))) {
            diffReport.addFileDiff(file, relativePath);
        }
    }

    private boolean computeDiffRecursively(INodeDirectory snapshotDir, INode node, List<byte[]> parentPath, SnapshotDiffListingInfo diffReport, byte[][] resume, int level, boolean processFlag) {
        INodeFile file;
        boolean change;
        Snapshot earlier = diffReport.getEarlier();
        Snapshot later = diffReport.getLater();
        byte[][] relativePath = (byte[][])parentPath.toArray((T[])new byte[parentPath.size()][]);
        if (!processFlag && level == resume.length && Arrays.equals(resume[resume.length - 1], node.getLocalNameBytes())) {
            processFlag = true;
        }
        if (node.isDirectory()) {
            boolean change2;
            DirectoryWithSnapshotFeature sf;
            DirectoryWithSnapshotFeature.ChildrenDiff diff = new DirectoryWithSnapshotFeature.ChildrenDiff();
            INodeDirectory dir = node.asDirectory();
            if (processFlag && (sf = dir.getDirectoryWithSnapshotFeature()) != null && (change2 = sf.computeDiffBetweenSnapshots(earlier, later, diff, dir)) && !diffReport.addDirDiff(dir.getId(), relativePath, diff)) {
                return false;
            }
            ReadOnlyList<INode> children = dir.getChildrenList(earlier.getId());
            boolean iterate = false;
            for (INode child : children) {
                byte[][] renameTargetPath;
                boolean toProcess;
                byte[] name = child.getLocalNameBytes();
                if (!processFlag && !iterate && !Arrays.equals(resume[level], name)) continue;
                iterate = true;
                ++level;
                boolean bl = toProcess = !diff.containsDeleted(name);
                if (!toProcess && child instanceof INodeReference.WithName && (renameTargetPath = this.findRenameTargetPath(snapshotDir, (INodeReference.WithName)child, Snapshot.getSnapshotId(later))) != null) {
                    toProcess = true;
                }
                if (!toProcess) continue;
                parentPath.add(name);
                processFlag = this.computeDiffRecursively(snapshotDir, child, parentPath, diffReport, resume, level, processFlag);
                parentPath.remove(parentPath.size() - 1);
                if (processFlag) continue;
                return false;
            }
        } else if (node.isFile() && node.asFile().isWithSnapshot() && processFlag && (change = (file = node.asFile()).getFileWithSnapshotFeature().changedBetweenSnapshots(file, earlier, later)) && !diffReport.addFileDiff(file, relativePath)) {
            return false;
        }
        return true;
    }

    public byte[][] findRenameTargetPath(INodeDirectory snapshotRoot, INodeReference.WithName wn, int snapshotId) {
        INode inode = wn.getReferredINode();
        LinkedList<byte[]> ancestors = Lists.newLinkedList();
        while (inode != null) {
            int sid;
            INode parent;
            if (inode == snapshotRoot) {
                return (byte[][])ancestors.toArray((T[])new byte[ancestors.size()][]);
            }
            if (inode instanceof INodeReference.WithCount) {
                inode = ((INodeReference.WithCount)inode).getParentRef(snapshotId);
                continue;
            }
            INode iNode = parent = inode.getParentReference() != null ? inode.getParentReference() : inode.getParent();
            if (parent != null && parent instanceof INodeDirectory && (sid = parent.asDirectory().searchChild(inode)) < snapshotId) {
                return null;
            }
            if (!(parent instanceof INodeReference.WithCount)) {
                ancestors.addFirst(inode.getLocalNameBytes());
            }
            inode = parent;
        }
        return null;
    }

    public String toString() {
        return "snapshotsByNames=" + this.snapshotsByNames;
    }

    @VisibleForTesting
    public void dumpTreeRecursively(INodeDirectory snapshotRoot, PrintWriter out, StringBuilder prefix, int snapshot) {
        if (snapshot == 0x7FFFFFFE) {
            out.println();
            out.print(prefix);
            out.print("Snapshot of ");
            String name = snapshotRoot.getLocalName();
            out.print(name.isEmpty() ? "/" : name);
            out.print(": quota=");
            out.print(this.getSnapshotQuota());
            int n = 0;
            for (DirectoryWithSnapshotFeature.DirectoryDiff diff : this.getDiffs()) {
                if (!diff.isSnapshotRoot()) continue;
                ++n;
            }
            Preconditions.checkState(n == this.snapshotsByNames.size(), "#n=" + n + ", snapshotsByNames.size()=" + this.snapshotsByNames.size());
            out.print(", #snapshot=");
            out.println(n);
            INodeDirectory.dumpTreeRecursively(out, prefix, new Iterable<INodeDirectory.SnapshotAndINode>(){

                @Override
                public Iterator<INodeDirectory.SnapshotAndINode> iterator() {
                    return new Iterator<INodeDirectory.SnapshotAndINode>(){
                        final Iterator<DirectoryWithSnapshotFeature.DirectoryDiff> i;
                        private DirectoryWithSnapshotFeature.DirectoryDiff next;
                        {
                            this.i = DirectorySnapshottableFeature.this.getDiffs().iterator();
                            this.next = this.findNext();
                        }

                        private DirectoryWithSnapshotFeature.DirectoryDiff findNext() {
                            while (this.i.hasNext()) {
                                DirectoryWithSnapshotFeature.DirectoryDiff diff = this.i.next();
                                if (!diff.isSnapshotRoot()) continue;
                                return diff;
                            }
                            return null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public INodeDirectory.SnapshotAndINode next() {
                            INodeDirectory.SnapshotAndINode pair = new INodeDirectory.SnapshotAndINode(this.next.getSnapshotId(), DirectorySnapshottableFeature.this.getSnapshotById(this.next.getSnapshotId()).getRoot());
                            this.next = this.findNext();
                            return pair;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            });
        }
    }
}

